/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.application;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import javax.inject.Singleton;
import juzu.Scope;
import juzu.impl.common.Filter;
import juzu.impl.common.JSON;
import juzu.impl.common.Tools;
import juzu.impl.inject.BeanDescriptor;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.inject.spi.Injector;
import juzu.impl.plugin.Plugin;
import juzu.impl.plugin.PluginContext;
import juzu.impl.plugin.PluginDescriptor;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.plugin.application.descriptor.ApplicationDescriptor;
import juzu.impl.resource.ResourceResolver;

@Singleton
public class Application
implements ResourceResolver {
    private final ApplicationDescriptor descriptor;
    InjectionContext<?, ?> injectionContext;
    final ResourceResolver resourceResolver;
    final Injector injector;
    private Map<String, ApplicationPlugin> plugins;
    private final ClassLoader classLoader;

    public Application(Injector injector, ApplicationDescriptor descriptor, ResourceResolver resourceResolver) {
        this.classLoader = descriptor.getApplicationLoader();
        this.injectionContext = null;
        this.descriptor = descriptor;
        this.injector = injector;
        this.resourceResolver = resourceResolver;
        this.plugins = Collections.emptyMap();
    }

    public void start() throws Exception {
        String name;
        final ResourceResolver applicationResolver = new ResourceResolver(){

            @Override
            public URL resolve(String uri) {
                if (uri == null) {
                    throw new NullPointerException("No null URI accepted");
                }
                if (uri.startsWith("/")) {
                    return Application.this.classLoader.getResource(uri.substring(1));
                }
                return null;
            }
        };
        HashMap<String, ApplicationPlugin> plugins = new HashMap<String, ApplicationPlugin>();
        for (ApplicationPlugin plugin : ServiceLoader.load(ApplicationPlugin.class)) {
            plugins.put(plugin.getName(), plugin);
        }
        HashSet<String> names = new HashSet<String>(this.descriptor.getConfig().names());
        HashMap<ApplicationPlugin, JSON> configs = new HashMap<ApplicationPlugin, JSON>();
        for (ApplicationPlugin plugin : plugins.values()) {
            name = plugin.getName();
            if (names.remove(name)) {
                configs.put(plugin, this.descriptor.getConfig().getJSON(plugin.getName()));
                continue;
            }
            configs.put(plugin, null);
        }
        if (names.size() > 0) {
            throw new UnsupportedOperationException("Handle me gracefully : missing plugins " + names);
        }
        HashMap<String, PluginDescriptor> pluginDescriptors = new HashMap<String, PluginDescriptor>();
        for (final Map.Entry entry : configs.entrySet()) {
            ApplicationPlugin plugin = (ApplicationPlugin)entry.getKey();
            PluginContext pluginContext = new PluginContext(){

                @Override
                public JSON getConfig() {
                    return (JSON)entry.getValue();
                }

                @Override
                public ClassLoader getClassLoader() {
                    return Application.this.classLoader;
                }

                @Override
                public ResourceResolver getServerResolver() {
                    return Application.this.resourceResolver;
                }

                @Override
                public ResourceResolver getApplicationResolver() {
                    return applicationResolver;
                }
            };
            plugin.setApplication(this.descriptor);
            PluginDescriptor pluginDescriptor = plugin.init(pluginContext);
            if (pluginDescriptor == null) continue;
            pluginDescriptors.put(plugin.getName(), pluginDescriptor);
        }
        Iterator i = plugins.keySet().iterator();
        while (i.hasNext()) {
            name = (String)i.next();
            if (pluginDescriptors.containsKey(name)) continue;
            i.remove();
        }
        for (Plugin plugin : plugins.values()) {
            Class<?> aClass = plugin.getClass();
            Plugin o = plugin;
            this.injector.bindBean(aClass, null, o);
        }
        for (PluginDescriptor pluginDescriptor : pluginDescriptors.values()) {
            for (BeanDescriptor bean : pluginDescriptor.getBeans()) {
                bean.bind(this.injector);
            }
        }
        this.injector.bindBean(ApplicationDescriptor.class, null, this.descriptor);
        this.injector.bindBean(Application.class, null, this);
        for (Scope scope : Scope.values()) {
            this.injector.addScope(scope);
        }
        Filter filter = new Filter<Class<?>, Boolean>(){
            HashSet<String> blackList = new HashSet();

            @Override
            public Boolean filter(Class<?> source) {
                if (source.getName().startsWith("juzu.")) {
                    return false;
                }
                if (source.getPackage().getName().startsWith(Application.this.descriptor.getPackageName())) {
                    return true;
                }
                String currentPkg = source.getPackage().getName();
                while (currentPkg != null) {
                    if (this.blackList.contains(currentPkg)) {
                        return false;
                    }
                    try {
                        Class<?> packageClass = Application.this.classLoader.loadClass(currentPkg + ".package-info");
                        juzu.Application ann = packageClass.getAnnotation(juzu.Application.class);
                        if (ann != null) {
                            this.blackList.add(currentPkg);
                            return false;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    currentPkg = Tools.parentPackageOf(currentPkg);
                }
                return true;
            }
        };
        try {
            this.injectionContext = this.injector.create(filter);
            this.plugins = plugins;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("handle me gracefully", e);
        }
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public ClassLoader getClassLoader() {
        return this.injectionContext.getClassLoader();
    }

    public InjectionContext<?, ?> getInjectionContext() {
        return this.injectionContext;
    }

    public <T> T resolveBean(Class<T> beanType) {
        return this.injectionContext.resolveInstance(beanType);
    }

    public <T> Iterable<T> resolveBeans(Class<T> beanType) {
        return this.injectionContext.resolveInstances(beanType);
    }

    public ApplicationPlugin getPlugin(String pluginName) {
        return this.plugins.get(pluginName);
    }

    public ApplicationDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Object resolveBean(String name) throws InvocationTargetException {
        return this.resolveBean(this.injectionContext, name);
    }

    @Override
    public URL resolve(String uri) {
        return this.classLoader.getResource(uri.substring(1));
    }

    private <B, I> Object resolveBean(InjectionContext<B, I> manager, String name) throws InvocationTargetException {
        B bean = manager.resolveBean(name);
        if (bean != null) {
            I cc = manager.createContext(bean);
            return manager.getInstance(bean, cc);
        }
        return null;
    }
}

