/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.asset;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import juzu.asset.AssetLocation;
import juzu.impl.common.JSON;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModelPlugin;
import juzu.impl.plugin.asset.Asset;
import juzu.impl.plugin.asset.AssetsMetaModel;
import juzu.plugin.asset.Scripts;
import juzu.plugin.asset.Stylesheets;

public class AssetMetaModelPlugin
extends ApplicationMetaModelPlugin {
    public static final MessageCode ASSET_NOT_FOUND = new MessageCode("ASSET_NOT_FOUND", "The asset %1$s cannot be resolved");
    private static final Set<Class<? extends Annotation>> ANNOTATIONS;

    public AssetMetaModelPlugin() {
        super("asset");
    }

    @Override
    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        return ANNOTATIONS;
    }

    @Override
    public void init(ApplicationMetaModel metaModel) {
        metaModel.addChild(AssetsMetaModel.KEY, new AssetsMetaModel(metaModel.getHandle()));
    }

    @Override
    public void processAnnotationAdded(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState added) {
        if (metaModel.getHandle().equals(key.getElement())) {
            AssetsMetaModel assetsMetaModel = metaModel.getChild(AssetsMetaModel.KEY);
            Integer maxAge = (Integer)added.get("maxAge");
            String identifier = key.getType().getIdentifier();
            String type = identifier.equals(Scripts.class.getSimpleName()) ? "script" : "stylesheet";
            for (Asset asset : this.getAssets(metaModel, type, added, maxAge)) {
                assetsMetaModel.addAsset(asset);
            }
        }
    }

    @Override
    public void processAnnotationRemoved(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState removed) {
        if (metaModel.getHandle().equals(key.getElement())) {
            AssetsMetaModel assetsMetaModel = metaModel.getChild(AssetsMetaModel.KEY);
            for (Asset asset : this.getAssets(metaModel, null, removed, null)) {
                assetsMetaModel.removeAsset(asset);
            }
        }
    }

    private Iterable<Asset> getAssets(ApplicationMetaModel metaModel, String type, AnnotationState annotation, Integer maxAge) {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        String location = (String)annotation.get("location");
        if (location == null) {
            location = AssetLocation.APPLICATION.name();
        }
        List value = (List)annotation.get("value");
        for (AnnotationState asset : value) {
            HashMap<String, Serializable> state = new HashMap<String, Serializable>(asset);
            if (state.get("location") == null) {
                state.put("location", (Serializable)((Object)location));
            }
            if (maxAge != null && state.get("maxAge") == null) {
                state.put("maxAge", maxAge);
            }
            if (state.get("id") == null) {
                state.put("id", (Serializable)state.get("value"));
            }
            assets.add(new Asset(type, state));
        }
        return assets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prePassivate(ApplicationMetaModel metaModel) {
        ProcessingContext context = metaModel.getProcessingContext();
        Name qn = metaModel.getHandle().getPackageName().append("assets");
        if (!context.isCopyFromSourcesExternallyManaged()) {
            AssetsMetaModel annotation = metaModel.getChild(AssetsMetaModel.KEY);
            HashMap<String, URL> bilta = new HashMap<String, URL>();
            HashMap<URL, Asset> bilto = new HashMap<URL, Asset>();
            for (Asset asset : annotation.getAssets()) {
                if (!asset.isApplication()) continue;
                for (Map.Entry<String, String> entry : asset.getSources().entrySet()) {
                    String source = entry.getKey();
                    if (source.startsWith("/")) continue;
                    URL resource = annotation.getResources().get(source);
                    if (resource == null) {
                        resource = annotation.resolveResource(source);
                    }
                    if (resource != null) {
                        bilto.put(resource, asset);
                        bilta.put(entry.getValue(), resource);
                        continue;
                    }
                    throw ASSET_NOT_FOUND.failure(source);
                }
            }
            bilta.putAll(annotation.getResources());
            for (Map.Entry entry : bilta.entrySet()) {
                InputStream in = null;
                OutputStream out = null;
                try {
                    URL src = (URL)entry.getValue();
                    URLConnection conn = src.openConnection();
                    FileObject dst = context.getResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, qn, (CharSequence)entry.getKey());
                    if (dst == null || dst.getLastModified() < conn.getLastModified()) {
                        dst = context.createResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, qn, (CharSequence)entry.getKey(), context.get(metaModel.getHandle()));
                        context.info("Copying asset from source path " + src + " to class output " + dst.toUri());
                        Asset r = (Asset)bilto.remove(entry.getValue());
                        in = r != null ? r.open(conn) : conn.getInputStream();
                        out = dst.openOutputStream();
                        Tools.copy(in, out);
                        continue;
                    }
                    context.info("Found up to date related asset in class output for " + src);
                }
                catch (IOException e) {
                    context.info("Could not copy asset " + (String)entry.getKey() + " ", e);
                }
                finally {
                    Tools.safeClose(in);
                    Tools.safeClose(out);
                }
            }
        }
    }

    @Override
    public JSON getDescriptor(ApplicationMetaModel application) {
        AssetsMetaModel assetsMetaModel = application.getChild(AssetsMetaModel.KEY);
        Iterator<Asset> assets = assetsMetaModel.getAssets().iterator();
        if (assets.hasNext()) {
            JSON json = new JSON();
            ArrayList<JSON> list = new ArrayList<JSON>();
            while (assets.hasNext()) {
                list.add(assets.next().getJSON());
            }
            json.set("assets", list);
            json.set("package", "assets");
            return json;
        }
        return null;
    }

    static {
        HashSet<Class> tmp = new HashSet<Class>();
        tmp.add(Scripts.class);
        tmp.add(Stylesheets.class);
        ANNOTATIONS = Collections.unmodifiableSet(tmp);
    }
}

