/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import juzu.impl.plugin.controller.AmbiguousResolutionException;
import juzu.request.Phase;

public abstract class ControllerResolver<M> {
    public abstract M[] getMethods();

    public abstract String getId(M var1);

    public abstract Phase getPhase(M var1);

    public abstract String getName(M var1);

    public abstract boolean isDefault(M var1);

    public final boolean isIndex(M method) {
        return this.isDefault(method) && "index".equals(this.getName(method));
    }

    public abstract Collection<String> getParameterNames(M var1);

    public final M resolve(Phase phase, Set<String> parameterNames) throws NullPointerException, AmbiguousResolutionException {
        if (parameterNames == null) {
            throw new NullPointerException("No null parameter names accepted");
        }
        ArrayList<Match> matches = new ArrayList<Match>();
        for (M method : this.getMethods()) {
            if (this.getPhase(method) != phase) continue;
            if (phase == Phase.VIEW) {
                if (!this.getName(method).equals("index")) continue;
                matches.add(new Match(parameterNames, method));
                continue;
            }
            matches.add(new Match(parameterNames, method));
        }
        return this.select(matches);
    }

    public final M resolveMethod(Phase phase, String methodId, Set<String> parameterNames) throws NullPointerException, AmbiguousResolutionException {
        if (parameterNames == null) {
            throw new NullPointerException("No null parameter names accepted");
        }
        if (phase == null) {
            throw new NullPointerException("Phase parameter cannot be null");
        }
        ArrayList<Match> matches = new ArrayList<Match>();
        for (M method : this.getMethods()) {
            if (this.getPhase(method) != phase || methodId != null && !methodId.equals(this.getId(method))) continue;
            matches.add(new Match(parameterNames, method));
        }
        return this.select(matches);
    }

    public final List<M> resolveMethods(Phase phase, String methodId, Set<String> parameterNames) throws NullPointerException, AmbiguousResolutionException {
        if (parameterNames == null) {
            throw new NullPointerException("No null parameter names accepted");
        }
        if (phase == null) {
            throw new NullPointerException("Phase parameter cannot be null");
        }
        ArrayList<Match> matches = new ArrayList<Match>();
        for (M method : this.getMethods()) {
            if (this.getPhase(method) != phase || methodId != null && !methodId.equals(this.getId(method))) continue;
            matches.add(new Match(parameterNames, method));
        }
        Collections.sort(matches);
        ArrayList methods = new ArrayList(matches.size());
        for (Match match : matches) {
            methods.add(match.method);
        }
        return methods;
    }

    public M resolve(String typeName, String methodName, Set<String> parameterNames) throws NullPointerException, AmbiguousResolutionException {
        if (parameterNames == null) {
            throw new NullPointerException("No null parameter names accepted");
        }
        if (methodName == null) {
            throw new NullPointerException("Phase parameter cannot be null");
        }
        ArrayList<Match> matches = new ArrayList<Match>();
        for (M method : this.getMethods()) {
            if (!this.getParameterNames(method).containsAll(parameterNames)) continue;
            if (typeName == null) {
                if (!this.getName(method).equals(methodName)) continue;
                matches.add(new Match(parameterNames, method));
                continue;
            }
            String id = typeName + "." + methodName;
            if (!this.getId(method).equals(id)) continue;
            matches.add(new Match(parameterNames, method));
        }
        return this.select(matches);
    }

    private M select(List<Match> matches) throws AmbiguousResolutionException {
        M found = null;
        if (matches.size() > 0) {
            Match second;
            Collections.sort(matches);
            Match first = matches.get(0);
            if (matches.size() > 1 && first.compareTo(second = matches.get(1)) == 0) {
                throw new AmbiguousResolutionException("Two methods satisfies the index criteria: " + first.method + " and " + second.method);
            }
            found = first.method;
        }
        return found;
    }

    private class Match
    implements Comparable<Match> {
        final M method;
        final int score1;
        final int score2;
        final int score3;
        final int score4;

        Match(Set<String> parameterNames, M method) {
            this.method = method;
            HashSet<String> a = new HashSet<String>(parameterNames);
            a.retainAll(ControllerResolver.this.getParameterNames(method));
            this.score1 = a.size();
            a = new HashSet<String>(ControllerResolver.this.getParameterNames(method));
            a.removeAll(parameterNames);
            this.score2 = a.size();
            a = new HashSet<String>(parameterNames);
            a.removeAll(ControllerResolver.this.getParameterNames(method));
            this.score3 = a.size();
            this.score4 = ControllerResolver.this.isDefault(method) ? 0 : 1;
        }

        @Override
        public int compareTo(Match o) {
            int delta = o.score1 - this.score1;
            if (delta == 0 && (delta = this.score2 - o.score2) == 0 && (delta = this.score3 - o.score3) == 0) {
                delta = this.score4 - o.score4;
            }
            return delta;
        }

        public String toString() {
            return "Match[score1=" + this.score1 + ",score2=" + this.score2 + ",score3=" + this.score3 + ",score4=" + this.score4 + ",method=" + this.method + "]";
        }
    }
}

