/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.request;

import java.beans.Introspector;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import juzu.Mapped;
import juzu.impl.bridge.Parameters;
import juzu.impl.common.MethodHandle;
import juzu.impl.common.Tools;
import juzu.impl.request.ContextualParameter;
import juzu.impl.request.ControlParameter;
import juzu.impl.request.PhaseParameter;
import juzu.request.Phase;
import juzu.request.RequestParameter;

public final class Method<P extends Phase> {
    private final String id;
    private final P phase;
    private final Class<?> type;
    private final java.lang.reflect.Method method;
    private final List<ControlParameter> parameterList;
    private final Map<String, ControlParameter> parameterMap;
    private final boolean requiresPrefix;
    private final MethodHandle handle;

    public Method(String id, P phase, Class<?> type, java.lang.reflect.Method method, List<ControlParameter> parameterList) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        parameterList = new ArrayList<ControlParameter>(parameterList);
        for (int i = 0; i < parameterList.size(); ++i) {
            ControlParameter parameter = parameterList.get(i);
            if (!(parameter instanceof ContextualParameter)) continue;
            Type genericParameterType = genericParameterTypes[i];
            parameterList.set(i, new ContextualParameter(parameter.getName(), parameterTypes[i], genericParameterType));
        }
        LinkedHashMap<String, ControlParameter> argumentMap = new LinkedHashMap<String, ControlParameter>();
        for (ControlParameter argument : parameterList) {
            argumentMap.put(argument.getName(), argument);
        }
        boolean requiresPrefix = false;
        HashSet<String> set = new HashSet<String>();
        block2: for (ControlParameter parameter : parameterList) {
            if (!(parameter instanceof PhaseParameter)) continue;
            PhaseParameter phaseParameter = (PhaseParameter)parameter;
            if (phaseParameter.getType() == String.class) {
                if (set.add(parameter.getName())) continue;
                requiresPrefix = true;
                break;
            }
            for (Field field : phaseParameter.getType().getFields()) {
                if (set.add(field.getName())) continue;
                requiresPrefix = true;
                break;
            }
            for (AccessibleObject accessibleObject : phaseParameter.getType().getMethods()) {
                String name;
                String methodName = ((java.lang.reflect.Method)accessibleObject).getName();
                if (methodName.length() <= 3 || !methodName.startsWith("get") || ((java.lang.reflect.Method)accessibleObject).getParameterTypes().length != 0 || ((java.lang.reflect.Method)accessibleObject).getReturnType() == Void.class || set.add(name = Introspector.decapitalize(methodName.substring("get".length())))) continue;
                requiresPrefix = true;
                continue block2;
            }
        }
        this.id = id;
        this.phase = phase;
        this.type = type;
        this.method = method;
        this.parameterList = Tools.safeUnmodifiableList(parameterList);
        this.parameterMap = Collections.unmodifiableMap(argumentMap);
        this.requiresPrefix = requiresPrefix;
        this.handle = new MethodHandle(method);
    }

    public MethodHandle getHandle() {
        return this.handle;
    }

    public String getId() {
        return this.id;
    }

    public P getPhase() {
        return this.phase;
    }

    public Class<?> getType() {
        return this.type;
    }

    public java.lang.reflect.Method getMethod() {
        return this.method;
    }

    public String getName() {
        return this.method.getName();
    }

    public ControlParameter getParameter(String name) {
        return this.parameterMap.get(name);
    }

    public List<ControlParameter> getParameters() {
        return this.parameterList;
    }

    public Set<String> getParameterNames() {
        return this.parameterMap.keySet();
    }

    public void setArgs(Object[] args, Parameters parameterMap) {
        int index = 0;
        block5: for (ControlParameter parameter : this.parameterList) {
            Object value;
            if (!(parameter instanceof PhaseParameter)) continue;
            PhaseParameter phaseParameter = (PhaseParameter)parameter;
            if ((value = args[index++]) == null) continue;
            String name = phaseParameter.getMappedName();
            switch (phaseParameter.getCardinality()) {
                case SINGLE: {
                    if (phaseParameter.getType().isAnnotationPresent(Mapped.class)) {
                        Map<String, String[]> p = this.buildBeanParameter(name, value);
                        parameterMap.setParameters(p);
                        continue block5;
                    }
                    parameterMap.setParameter(name, String.valueOf(value));
                    continue block5;
                }
                case ARRAY: {
                    int length = Array.getLength(value);
                    String[] array = new String[length];
                    for (int i = 0; i < length; ++i) {
                        Object component = Array.get(value, i);
                        array[i] = String.valueOf(component);
                    }
                    parameterMap.setParameter(name, array);
                    continue block5;
                }
                case LIST: {
                    Collection c = (Collection)value;
                    int length = c.size();
                    String[] array = new String[length];
                    Iterator iterator = c.iterator();
                    for (int i = 0; i < length; ++i) {
                        Object element = iterator.next();
                        array[i] = String.valueOf(element);
                    }
                    parameterMap.setParameter(name, array);
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }

    private Map<String, String[]> buildBeanParameter(String baseName, Object value) {
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        try {
            Object v;
            for (Field field : value.getClass().getFields()) {
                v = field.get(value);
                if (v == null) continue;
                String name = this.requiresPrefix ? baseName + "." + field.getName() : field.getName();
                this.addParameter(parameters, name, field.getType(), v);
            }
            for (AccessibleObject accessibleObject : value.getClass().getMethods()) {
                if (!((java.lang.reflect.Method)accessibleObject).getName().startsWith("get") || ((java.lang.reflect.Method)accessibleObject).getName().length() <= 3 || ((java.lang.reflect.Method)accessibleObject).getParameterTypes().length != 0 || (v = ((java.lang.reflect.Method)accessibleObject).invoke(value, new Object[0])) == null) continue;
                String n = Character.toLowerCase(((java.lang.reflect.Method)accessibleObject).getName().charAt(3)) + ((java.lang.reflect.Method)accessibleObject).getName().substring(4);
                String name = this.requiresPrefix ? baseName + "." + n : n;
                this.addParameter(parameters, name, ((java.lang.reflect.Method)accessibleObject).getReturnType(), v);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return parameters;
    }

    private void addParameter(Map<String, String[]> parameters, String name, Class clazz, Object value) {
        if (String.class.equals((Object)clazz)) {
            parameters.put(name, new String[]{(String)value});
        } else if (String[].class.equals((Object)clazz)) {
            parameters.put(name, (String[])value);
        } else if (List.class.equals((Object)clazz)) {
            parameters.put(name, (String[])((List)value).toArray());
        }
    }

    public Map<ControlParameter, Object> getArguments(Map<String, RequestParameter> parameterMap) {
        HashMap<ControlParameter, Object> arguments = new HashMap<ControlParameter, Object>();
        for (ControlParameter controlParam : this.parameterMap.values()) {
            ArrayList arg;
            Object[] values;
            if (!(controlParam instanceof PhaseParameter)) continue;
            PhaseParameter phaseParameter = (PhaseParameter)controlParam;
            Class<?> type = phaseParameter.getType();
            if (type.isAnnotationPresent(Mapped.class)) {
                Object o = null;
                try {
                    o = this.createMappedBean(type, phaseParameter.getMappedName(), parameterMap);
                }
                catch (Exception e) {
                    // empty catch block
                }
                values = new Object[]{o};
            } else {
                RequestParameter requestParam = parameterMap.get(phaseParameter.getMappedName());
                Object[] objectArray = values = requestParam != null ? requestParam.toArray() : null;
            }
            if (values == null) continue;
            switch (phaseParameter.getCardinality()) {
                case SINGLE: {
                    arg = values.length > 0 ? values[0] : null;
                    break;
                }
                case ARRAY: {
                    arg = values.clone();
                    break;
                }
                case LIST: {
                    ArrayList list = new ArrayList(values.length);
                    Collections.addAll(list, values);
                    arg = list;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Handle me gracefully");
                }
            }
            arguments.put(controlParam, arg);
        }
        return arguments;
    }

    private <T> T createMappedBean(Class<T> clazz, String beanName, Map<String, RequestParameter> parameters) throws IllegalAccessException, InstantiationException {
        HashMap<String, String[]> beanParams = new HashMap<String, String[]>();
        String prefix = this.requiresPrefix ? beanName + "." : "";
        for (String key : parameters.keySet()) {
            if (!key.startsWith(prefix)) continue;
            String paramName = key.substring(prefix.length());
            beanParams.put(paramName, parameters.get(key).toArray());
        }
        T bean = clazz.newInstance();
        for (String key : beanParams.keySet()) {
            String[] value = (String[])beanParams.get(key);
            String setterName = "set" + key.substring(0, 1).toUpperCase() + key.substring(1);
            boolean success = this.callSetter(setterName, clazz, bean, value, String[].class);
            if (!success) {
                success = this.callSetter(setterName, clazz, bean, value[0], String.class);
            }
            if (!success) {
                success = this.callSetter(setterName, clazz, bean, Arrays.asList(value), List.class);
            }
            if (success) continue;
            try {
                Field f = clazz.getField(key);
                if (String[].class.equals(f.getType())) {
                    f.set(bean, value);
                    continue;
                }
                if (String.class.equals(f.getType())) {
                    f.set(bean, value[0]);
                    continue;
                }
                if (!List.class.equals(f.getType())) continue;
                f.set(bean, Arrays.asList(value));
            }
            catch (NoSuchFieldException e) {}
        }
        return bean;
    }

    <T> boolean callSetter(String methodName, Class<T> clazz, T target, Object value, Class type) {
        try {
            java.lang.reflect.Method m = clazz.getMethod(methodName, type);
            m.invoke(target, value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[type=").append(this.type.getName()).append(",method=");
        sb.append(this.method.getName()).append("(");
        Class<?>[] types = this.method.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.parameterList.get(i).getName()).append("=").append(types[i].getName());
        }
        sb.append(")]");
        return sb.toString();
    }
}

