/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.template;

import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import juzu.impl.common.Path;
import juzu.impl.plugin.PluginContext;
import juzu.impl.plugin.PluginDescriptor;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.plugin.template.metadata.TemplateDescriptor;
import juzu.impl.plugin.template.metadata.TemplatesDescriptor;
import juzu.impl.template.spi.TemplateStub;
import juzu.template.TagHandler;

public class TemplatePlugin
extends ApplicationPlugin {
    private TemplatesDescriptor descriptor;
    private final ConcurrentHashMap<Path, TemplateStub> stubs = new ConcurrentHashMap();
    private PluginContext context;
    private final ConcurrentHashMap<String, TagHandler> tags = new ConcurrentHashMap();

    public TemplatePlugin() {
        super("template");
    }

    public TemplatesDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public PluginDescriptor init(PluginContext context) throws Exception {
        this.context = context;
        this.descriptor = new TemplatesDescriptor(this.application, context.getClassLoader(), context.getConfig());
        return this.descriptor;
    }

    public TagHandler resolveTag(String name) {
        TagHandler tag = this.tags.get(name);
        if (tag == null) {
            try {
                Class<?> a = this.context.getClassLoader().loadClass(name);
                Class<TagHandler> tagHandlerClass = a.asSubclass(TagHandler.class);
                tag = tagHandlerClass.newInstance();
                this.tags.putIfAbsent(name, tag);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("handle me gracefully", e);
            }
        }
        return tag;
    }

    public TemplateStub resolveTemplateStub(String path) {
        return this.resolveTemplateStub(Path.parse(path));
    }

    public TemplateStub resolveTemplateStub(Path path) {
        TemplateStub stub = this.stubs.get(path);
        if (stub == null) {
            TemplateDescriptor desc;
            Path.Absolute resolved = this.descriptor.getPackage().resolve(path);
            try {
                Class<?> clazz = this.context.getClassLoader().loadClass(resolved.getName().toString());
                Field f = clazz.getField("DESCRIPTOR");
                desc = (TemplateDescriptor)f.get(null);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Handle me gracefully", e);
            }
            stub = desc.getStub();
            TemplateStub phantom = this.stubs.putIfAbsent(path, stub);
            if (phantom != null) {
                stub = phantom;
            } else {
                stub.init();
            }
        }
        return stub;
    }
}

