/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller.descriptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import juzu.Handler;
import juzu.Response;
import juzu.impl.common.JSON;
import juzu.impl.common.MethodHandle;
import juzu.impl.inject.BeanDescriptor;
import juzu.impl.plugin.ServiceDescriptor;
import juzu.impl.plugin.application.descriptor.ApplicationDescriptor;
import juzu.impl.plugin.controller.ControllerResolver;
import juzu.impl.plugin.controller.descriptor.ControllerDescriptor;
import juzu.impl.plugin.controller.descriptor.ControllerDescriptorResolver;
import juzu.impl.request.ControllerHandler;

public class ControllersDescriptor
extends ServiceDescriptor {
    private final Class<?> defaultController;
    private final Class<? extends Handler<Response.Error, Response>> errorController;
    private final List<ControllerDescriptor> controllers;
    private final ArrayList<ControllerHandler> handlers;
    private final ArrayList<BeanDescriptor> beans;
    private final Boolean escapeXML;
    private ControllerDescriptorResolver resolver;
    private final Map<MethodHandle, ControllerHandler> byHandle;

    public ControllersDescriptor(ApplicationDescriptor desc) throws Exception {
        this(desc.getApplicationLoader(), desc.getConfig().getJSON("controller"));
    }

    public ControllersDescriptor(ClassLoader loader, JSON config) throws Exception {
        ArrayList<ControllerDescriptor> controllers = new ArrayList<ControllerDescriptor>();
        ArrayList handlers = new ArrayList();
        ArrayList<BeanDescriptor> beans = new ArrayList<BeanDescriptor>();
        HashMap<MethodHandle, ControllerHandler> byHandle = new HashMap<MethodHandle, ControllerHandler>();
        for (String fqn : config.getList("controllers", String.class)) {
            Class<?> clazz = loader.loadClass(fqn);
            Field f = clazz.getField("DESCRIPTOR");
            ControllerDescriptor bean = (ControllerDescriptor)f.get(null);
            for (ControllerHandler<?> handler : bean.getHandlers()) {
                byHandle.put(handler.getHandle(), handler);
            }
            controllers.add(bean);
            handlers.addAll(bean.getHandlers());
            beans.add(BeanDescriptor.createFromBean(bean.getType(), null, null));
        }
        Boolean escapeXML = config.getBoolean("escapeXML");
        Class<?> defaultController = null;
        String defaultControllerName = config.getString("default");
        if (defaultControllerName != null) {
            defaultController = loader.loadClass(defaultControllerName);
        }
        Class<?> errorController = null;
        String errorControllerName = config.getString("error");
        if (errorControllerName != null) {
            errorController = loader.loadClass(errorControllerName);
            beans.add(BeanDescriptor.createFromBean(errorController, null, Collections.<Annotation>emptyList()));
        }
        this.escapeXML = escapeXML;
        this.defaultController = defaultController;
        this.errorController = errorController;
        this.controllers = controllers;
        this.handlers = handlers;
        this.beans = beans;
        this.resolver = new ControllerDescriptorResolver(this);
        this.byHandle = byHandle;
    }

    @Override
    public Iterable<BeanDescriptor> getBeans() {
        return this.beans;
    }

    public ControllerResolver<ControllerHandler> getResolver() {
        return this.resolver;
    }

    public Class<?> getDefaultController() {
        return this.defaultController;
    }

    public Class<? extends Handler<Response.Error, Response>> getErrorController() {
        return this.errorController;
    }

    public Boolean getEscapeXML() {
        return this.escapeXML;
    }

    public List<ControllerDescriptor> getControllers() {
        return this.controllers;
    }

    public List<ControllerHandler> getHandlers() {
        return this.handlers;
    }

    public ControllerHandler getHandler(Method method) {
        for (ControllerHandler handler : this.handlers) {
            Method m = handler.getMethod();
            if (!m.equals(method)) continue;
            return handler;
        }
        return null;
    }

    public ControllerHandler getHandler(Class<?> type, String name, Class<?> ... parameterTypes) {
        for (ControllerHandler handler : this.handlers) {
            Class<?>[] a;
            Method m = handler.getMethod();
            if (!type.equals(handler.getType()) || !m.getName().equals(name) || (a = m.getParameterTypes()).length != parameterTypes.length) continue;
            for (int j = 0; j < parameterTypes.length; ++j) {
                if (a[j].equals(parameterTypes[j])) continue;
            }
            return handler;
        }
        return null;
    }

    public ControllerHandler getMethodById(String methodId) {
        for (int i = 0; i < this.handlers.size(); ++i) {
            ControllerHandler cm = this.handlers.get(i);
            if (!cm.getId().equals(methodId)) continue;
            return cm;
        }
        return null;
    }

    public ControllerHandler getMethodByHandle(MethodHandle handle) {
        return this.byHandle.get(handle);
    }
}

