/*
 * Decompiled with CFR 0.152.
 */
package juzu.arquillian;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class Helper {
    public static WebArchive createBaseServletDeployment() {
        return Helper.createBaseServletDeployment("guice");
    }

    public static WebArchive createBaseServletDeployment(String injectorVendor) {
        return Helper.createBaseDeployment(null, "servlet", injectorVendor);
    }

    public static WebArchive createBasePortletDeployment(Class ... baseClasses) {
        return Helper.createBasePortletDeployment((WebArchive)null, baseClasses);
    }

    public static WebArchive createBasePortletDeployment(WebArchive war, Class ... baseClasses) {
        return Helper.createBasePortletDeployment(war, "guice", baseClasses);
    }

    public static WebArchive createBasePortletDeployment(String injectorVendor, Class ... baseClasses) {
        return Helper.createBasePortletDeployment(null, injectorVendor, baseClasses);
    }

    public static WebArchive createBasePortletDeployment(WebArchive war, String injectorVendor, Class ... baseClasses) {
        war = Helper.createBaseDeployment(war, "portlet", injectorVendor);
        Helper.addClasses(war, baseClasses);
        return war;
    }

    public static void addClasses(WebArchive war, Class ... baseClasses) {
        for (Class baseClass : baseClasses) {
            try {
                URL root = baseClass.getClassLoader().getResource(baseClass.getName().replace('.', '/') + ".class");
                if (root == null) continue;
                File f = new File(root.toURI()).getParentFile();
                StringBuilder path = new StringBuilder(baseClass.getPackage().getName().replace('.', '/'));
                Helper.add(war, f, path);
            }
            catch (URISyntaxException e) {
                throw new AssertionError("Could not create portlet deployment for class " + baseClass.getName(), e);
            }
        }
    }

    private static void add(WebArchive war, File f, StringBuilder path) {
        if (f.isDirectory()) {
            File[] children = f.listFiles();
            if (children != null) {
                for (File child : children) {
                    int length = path.length();
                    path.append('/').append(child.getName());
                    Helper.add(war, child, path);
                    path.setLength(length);
                }
            }
        } else {
            war.addAsResource(f, path.toString());
        }
    }

    private static WebArchive createBaseDeployment(WebArchive war, String prefix, String injectorProvider) {
        String webXMLPath = prefix + "/" + (injectorProvider.equals("cdi") ? "web-cdi" : "web") + ".xml";
        if (war == null) {
            war = (WebArchive)ShrinkWrap.create(WebArchive.class);
        }
        String webXML = Helper.loadResource(webXMLPath);
        webXML = String.format(webXML, injectorProvider);
        war.setWebXML((Asset)new StringAsset(webXML));
        if ("cdi".equals(injectorProvider)) {
            String contextXML = Helper.loadResource("context.xml");
            war.addAsManifestResource((Asset)new StringAsset(contextXML), "context.xml");
        }
        return war;
    }

    private static String loadResource(String path) {
        byte[] buffer = new byte[512];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream in = Helper.class.getResourceAsStream(path);
        if (in == null) {
            throw new AssertionError((Object)("Could not locate " + path + " web.xml for juzu testing"));
        }
        try {
            int l22 = in.read(buffer);
            while (l22 != -1) {
                baos.write(buffer, 0, l22);
                l22 = in.read(buffer);
            }
            String l22 = baos.toString();
            return l22;
        }
        catch (IOException e) {
            throw new AssertionError((Object)("Could not find read " + path + " for juzu testing"));
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable ignore) {}
        }
    }
}

