/*
 * Decompiled with CFR 0.152.
 */
package examples.tutorial;

import examples.tutorial.WeatherTestCase;
import java.io.File;
import java.net.URL;
import junit.framework.AssertionFailedError;
import juzu.impl.bridge.DescriptorBuilder;
import juzu.impl.inject.spi.InjectorProvider;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class WeatherPortletTestCase
extends WeatherTestCase {
    @Deployment
    public static WebArchive deployment() {
        DescriptorBuilder desc = DescriptorBuilder.DEFAULT.injector(InjectorProvider.SPRING).embedPortletContainer().listener("org.springframework.web.context.ContextLoaderListener");
        String webXml = desc.toWebXml();
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class);
        war.setWebXML((Asset)new StringAsset(webXml));
        war.addAsWebInfResource(new File("src/test/resources/applicationContext.xml"));
        war.addAsWebInfResource(new File("src/main/webapp/WEB-INF/portlet.xml"));
        war.addPackages(true, new String[]{"examples.tutorial"});
        return war;
    }

    public URL getApplicationURL(String application) {
        try {
            return this.deploymentURL.toURI().resolve("embed/" + application).toURL();
        }
        catch (Exception e) {
            AssertionFailedError afe = new AssertionFailedError("Could not build URL");
            afe.initCause((Throwable)e);
            throw afe;
        }
    }
}

