/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.tutorial.juzcret.step7;

import com.google.common.base.Function;
import java.util.HashSet;
import java.util.List;
import juzu.test.AbstractWebTestCase;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class JuZcretTestCase
extends AbstractWebTestCase {
    @Drone
    WebDriver driver;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return JuZcretTestCase.createPortletDeployment((String)"org.juzu.tutorial.juzcret.step7");
    }

    @Test
    public void testRender() throws Exception {
        this.driver.get(this.getPortletURL().toString());
        WebElement body = this.driver.findElement(By.tagName((String)"body"));
        JuZcretTestCase.assertTrue((body.getText().indexOf("JuZcret Portlet") != -1 ? 1 : 0) != 0);
        System.out.println(this.driver.getPageSource());
    }

    @Test
    public void testSecret() throws Exception {
        this.driver.get(this.getPortletURL().toString());
        WebElement body = this.driver.findElement(By.tagName((String)"body"));
        JuZcretTestCase.assertFalse((boolean)body.getText().contains("test secret text"));
        WebElement shareBtn = this.driver.findElement(By.cssSelector((String)".secret-wall-heading a"));
        this.driver.get(shareBtn.getAttribute("href"));
        WebElement secretInput = this.driver.findElement(By.tagName((String)"textarea"));
        secretInput.sendKeys(new CharSequence[]{"test secret text"});
        WebElement submitBtn = this.driver.findElement(By.tagName((String)"button"));
        submitBtn.click();
        body = (WebElement)new WebDriverWait(this.driver, 10L).until((Function)new ExpectedCondition<WebElement>(){

            public WebElement apply(WebDriver drv) {
                return drv.findElement(By.tagName((String)"body"));
            }
        });
        JuZcretTestCase.assertTrue((boolean)body.getText().contains("test secret text"));
    }

    @Test
    public void testAsset() throws Exception {
        this.driver.get(this.getPortletURL().toString());
        List scripts = this.driver.findElements(By.tagName((String)"script"));
        HashSet<String> srcScripts = new HashSet<String>();
        for (WebElement elem : scripts) {
            srcScripts.add(elem.getAttribute("src"));
        }
        JuZcretTestCase.assertTrue((boolean)srcScripts.contains("http://localhost:8080/juzu/assets/org/juzu/tutorial/juzcret/step7/assets/jquery/1.10.2/jquery.js"));
        JuZcretTestCase.assertTrue((boolean)srcScripts.contains("http://localhost:8080/juzu/assets/juzu/impl/plugin/ajax/script.js"));
        JuZcretTestCase.assertTrue((boolean)srcScripts.contains("http://localhost:8080/juzu/assets/org/juzu/tutorial/juzcret/step7/assets/javascripts/secret.js"));
        WebElement style = this.driver.findElement(By.tagName((String)"link"));
        JuZcretTestCase.assertEquals((String)"http://localhost:8080/juzu/assets/org/juzu/tutorial/juzcret/step7/assets/styles/juzcret.css", (String)style.getAttribute("href"));
    }

    @Test
    public void testLike() throws Exception {
        this.driver.get(this.getPortletURL().toString());
        WebElement likeBtn = this.driver.findElement(By.cssSelector((String)".btn-like"));
        likeBtn.click();
        By selector = By.cssSelector((String)".btn-like .numb");
        ExpectedCondition condition = ExpectedConditions.textToBePresentInElement((By)selector, (String)"1");
        JuZcretTestCase.assertTrue((boolean)((Boolean)new WebDriverWait(this.driver, 10L).until((Function)condition)));
    }

    @Test
    public void testComment() throws Exception {
        this.driver.get(this.getPortletURL().toString());
        WebElement body = this.driver.findElement(By.tagName((String)"body"));
        JuZcretTestCase.assertFalse((boolean)body.getText().contains("test comment"));
        WebElement commentInput = this.driver.findElement(By.cssSelector((String)".secret-add-comment"));
        commentInput.sendKeys(new CharSequence[]{"test comment"});
        WebElement submitBtn = this.driver.findElement(By.cssSelector((String)".btn-comment"));
        submitBtn.click();
        ExpectedCondition condition = ExpectedConditions.textToBePresentInElement((By)By.cssSelector((String)".secr-comments-list"), (String)"test comment");
        JuZcretTestCase.assertTrue((boolean)((Boolean)new WebDriverWait(this.driver, 10L).until((Function)condition)));
    }
}

