/*
 * Decompiled with CFR 0.152.
 */
package org.juzu.tutorial.juzcret.step6.services;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.inject.Singleton;
import org.juzu.tutorial.juzcret.step6.models.Comment;
import org.juzu.tutorial.juzcret.step6.models.Secret;
import org.juzu.tutorial.juzcret.step6.services.SecretService;

@Singleton
public class SecretServiceMemImpl
implements SecretService {
    private List<Secret> secretsList;

    public List<Secret> getSecrets() {
        if (this.secretsList == null) {
            this.secretsList = new LinkedList();
            this.addFakeSecrets();
        }
        return this.secretsList;
    }

    public void addSecret(String message, String imageUrl) {
        Secret secret = new Secret();
        secret.setId(UUID.randomUUID().toString());
        secret.setMessage(message);
        secret.setImageURL(imageUrl);
        secret.setCreatedDate(new Date());
        this.secretsList.add(secret);
    }

    public Comment addComment(String secretId, Comment comment) {
        Secret secret = this.getSecret(secretId);
        if (secret != null) {
            comment.setId(UUID.randomUUID().toString());
            comment.setCreatedDate(new Date());
            List comments = secret.getComments();
            comments.add(comment);
            secret.setComments(comments);
        }
        return comment;
    }

    public Set<String> addLike(String secretId, String userId) {
        Secret secret = this.getSecret(secretId);
        if (secret != null) {
            Set likes = secret.getLikes();
            likes.add(userId);
            secret.setLikes(likes);
            return likes;
        }
        return null;
    }

    private Secret getSecret(String secretId) {
        Secret secret = null;
        for (Secret s : this.getSecrets()) {
            if (!s.getId().equals(secretId)) continue;
            secret = s;
        }
        return secret;
    }

    private void addFakeSecrets() {
        this.addSecret("Yesterday I said I missed my PL meeting because I have to many work. In fact I was drinking free beer in Barbetta pub", "https://c1.staticflickr.com/3/2385/2345543856_6d0fbafb66_z.jpg?zz=1");
        this.addSecret("I have a master degree but I still use Google to calculate 3*8", "https://yy2.staticflickr.com/7244/7245177220_3f17ee9fb8_z.jpg");
        this.addSecret("I am in relationship for 2 years. He is awesome, powerful and I never go out without him. His name is Linux", "http://fc02.deviantart.net/fs71/f/2009/364/9/d/christmas_love_by_skubaNiec.jpg");
        this.addSecret("I spent 2 hours a day to train my cat to perform a backflip", "http://fc06.deviantart.net/fs15/i/2007/008/e/b/colour_cat_wallpaper_by_jellyplant.jpg");
        this.addSecret("I pretend to be a spy when I go out. In reality my job is to perform photocopy at the embassy", "https://c2.staticflickr.com/2/1230/5108154392_3cc02cac67_z.jpg");
    }
}

