/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.portlet.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Generated;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.tools.JavaFileObject;
import juzu.impl.application.metamodel.ApplicationMetaModel;
import juzu.impl.application.metamodel.ApplicationMetaModelPlugin;
import juzu.impl.compiler.AnnotationData;
import juzu.impl.compiler.CompilationException;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.utils.FQN;
import juzu.impl.utils.JSON;
import juzu.impl.utils.Tools;
import juzu.plugin.portlet.Portlet;
import juzu.portlet.JuzuPortlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletMetaModelPlugin
extends ApplicationMetaModelPlugin {
    public static final MessageCode CANNOT_WRITE_PORTLET_CLASS = new MessageCode("CANNOT_WRITE_PORTLET_CLASS", "The portlet class %1$s cannot be written");
    private final HashMap<ElementHandle.Package, String[]> enabledMap = new HashMap();
    private HashSet<ElementHandle.Package> toEmit = new HashSet();

    public PortletMetaModelPlugin() {
        super("portlet");
    }

    public Set<Class<? extends Annotation>> getAnnotationTypes() {
        return Collections.singleton(Portlet.class);
    }

    public void processAnnotation(ApplicationMetaModel application, Element element, String fqn, AnnotationData data) {
        ElementHandle.Package pkg = application.getHandle();
        if (fqn.equals(Portlet.class.getName()) && ElementHandle.create((Element)element).equals((Object)pkg)) {
            String name = (String)data.get((Object)"name");
            if (name == null) {
                name = application.getBaseName() + "Portlet";
            }
            this.enabledMap.put(pkg, new String[]{name, application.getBaseName()});
            this.toEmit.add(pkg);
        }
    }

    public void preDestroy(ApplicationMetaModel application) {
        this.enabledMap.remove(application.getHandle());
    }

    public void postProcessEvents(ApplicationMetaModel application) {
        ElementHandle.Package pkg = application.getHandle();
        String[] names = this.enabledMap.get(pkg);
        if (names != null) {
            PackageElement pkgElt = (PackageElement)application.model.env.get((ElementHandle)pkg);
            AnnotationMirror am = Tools.getAnnotation((Element)pkgElt, (String)Portlet.class.getName());
            if (am == null) {
                this.enabledMap.remove(pkg);
                this.toEmit.remove(pkg);
            } else if (this.toEmit.contains(pkg)) {
                this.toEmit.remove(pkg);
                this.emitPortlet(application.model.env, pkgElt, names);
            }
        }
    }

    private void emitPortlet(ProcessingContext env, PackageElement pkgElt, String[] names) throws CompilationException {
        Writer writer = null;
        FQN fqn = new FQN((CharSequence)pkgElt.getQualifiedName(), (CharSequence)names[0]);
        try {
            JavaFileObject file = env.createSourceFile(fqn, new Element[]{pkgElt});
            writer = file.openWriter();
            writer.append("package ").append(pkgElt.getQualifiedName()).append(";\n");
            writer.append("import ").append(Tools.getImport(Generated.class)).append(";\n");
            writer.append("@Generated(value={})\n");
            writer.append("public class ").append(names[0]).append(" extends ").append(JuzuPortlet.class.getName()).append(" {\n");
            writer.append("@Override\n");
            writer.append("protected String getApplicationName(javax.portlet.PortletConfig config) {\n");
            writer.append("return \"").append(names[1]).append("Application\";\n");
            writer.append("}\n");
            writer.append("}\n");
        }
        catch (IOException e) {
            try {
                throw CANNOT_WRITE_PORTLET_CLASS.failure(new Object[]{e, pkgElt, fqn});
            }
            catch (Throwable throwable) {
                Tools.safeClose(writer);
                throw throwable;
            }
        }
        Tools.safeClose((Closeable)writer);
    }

    public JSON getDescriptor(ApplicationMetaModel application) {
        return new JSON();
    }
}

