/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.shiro.impl;

import javax.servlet.http.Cookie;
import juzu.impl.request.Request;
import juzu.request.HttpContext;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.mgt.AbstractRememberMeManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.SubjectContext;

public class JuzuRememberMe
extends AbstractRememberMeManager {
    private final String DEFAULT_REMEMBER_ME_COOKIE_NAME = "rememberMe";
    private final String DELETED_COOKIE_VALUE = "deleteMe";

    protected byte[] getRememberedSerializedIdentity(SubjectContext subjectContext) {
        String base64 = this.readCookieValue("rememberMe");
        if ("deleteMe".equals(base64)) {
            return null;
        }
        if (base64 != null) {
            base64 = this.ensurePadding(base64);
            return Base64.decode((String)base64);
        }
        return null;
    }

    private String ensurePadding(String base64) {
        int length = base64.length();
        if (length % 4 != 0) {
            StringBuilder sb = new StringBuilder(base64);
            for (int i = 0; i < length % 4; ++i) {
                sb.append('=');
            }
            base64 = sb.toString();
        }
        return base64;
    }

    private String readCookieValue(String name) {
        HttpContext context = Request.getCurrent().getBridge().getHttpContext();
        Cookie[] cookies = context.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public void forgetIdentity(SubjectContext subjectContext) {
    }

    protected void forgetIdentity(Subject subject) {
    }

    protected void rememberSerializedIdentity(Subject subject, byte[] serialized) {
    }
}

