/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.shiro.impl;

import java.util.List;
import juzu.Response;
import juzu.impl.request.ContextualParameter;
import juzu.impl.request.ControlParameter;
import juzu.impl.request.Request;
import juzu.impl.request.Stage;
import juzu.plugin.shiro.Login;
import juzu.plugin.shiro.impl.common.RememberMeUtil;
import juzu.request.RequestParameter;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;

public class ShiroAuthenticator {
    private final boolean rememberMeSupported;

    public ShiroAuthenticator(boolean rememberMeSupported) {
        this.rememberMeSupported = rememberMeSupported;
    }

    public Response doLogout(Stage.Handler request) {
        SecurityUtils.getSubject().logout();
        Response resp = request.invoke();
        if (this.rememberMeSupported) {
            RememberMeUtil.forgetIdentity();
        }
        return resp;
    }

    public Response doLogin(Stage.Handler stage) {
        Request request = stage.getRequest();
        Login loginAnnotation = request.getHandler().getMethod().getAnnotation(Login.class);
        Subject subject = SecurityUtils.getSubject();
        boolean remember = request.getParameterArguments().get(loginAnnotation.rememberMe()) != null;
        String username = null;
        String password = null;
        try {
            username = ((RequestParameter)request.getParameterArguments().get(loginAnnotation.username())).getValue();
            password = ((RequestParameter)request.getParameterArguments().get(loginAnnotation.password())).getValue();
        }
        catch (NullPointerException e) {
            List parameters = request.getHandler().getParameters();
            for (ControlParameter parameter : parameters) {
                if (!(parameter instanceof ContextualParameter) || !AuthenticationException.class.isAssignableFrom(parameter.getType())) continue;
                request.getContextualArguments().put((ContextualParameter)parameter, new AuthenticationException(e.getCause()));
                return stage.invoke();
            }
            return new Response.Error((Throwable)e);
        }
        try {
            subject.login((AuthenticationToken)new UsernamePasswordToken(username, password.toCharArray(), remember));
            Response resp = stage.invoke();
            if (remember && this.rememberMeSupported) {
                RememberMeUtil.forgetIdentity();
                RememberMeUtil.rememberSerialized();
            }
            return resp;
        }
        catch (AuthenticationException e) {
            List parameters = request.getHandler().getParameters();
            for (ControlParameter parameter : parameters) {
                if (!(parameter instanceof ContextualParameter) || !AuthenticationException.class.isAssignableFrom(parameter.getType())) continue;
                request.getContextualArguments().put((ContextualParameter)parameter, e);
                Response resp = stage.invoke();
                if (remember) {
                    RememberMeUtil.forgetIdentity();
                }
                return resp;
            }
            return new Response.Error((Throwable)e);
        }
    }
}

