/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.shiro.impl;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import juzu.impl.common.JSON;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModelPlugin;
import juzu.impl.plugin.controller.metamodel.ControllerMetaModel;
import juzu.impl.plugin.controller.metamodel.ControllersMetaModel;
import juzu.impl.plugin.controller.metamodel.HandlerMetaModel;
import juzu.plugin.shiro.Login;
import juzu.plugin.shiro.Logout;
import juzu.plugin.shiro.Shiro;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresGuest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;

public class ShiroMetaModelPlugin
extends ApplicationMetaModelPlugin {
    private final Map<ElementHandle.Package, JSON> enableMap = new HashMap<ElementHandle.Package, JSON>();
    private final Map<ElementHandle<?>, Map<AnnotationKey, AnnotationState>> methods = new HashMap();
    private final Map<ElementHandle<?>, Map<AnnotationKey, AnnotationState>> controllers = new HashMap();

    public ShiroMetaModelPlugin() {
        super("shiro");
    }

    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        return Tools.set((Object[])new Class[]{Shiro.class, RequiresGuest.class, RequiresUser.class, RequiresAuthentication.class, RequiresPermissions.class, RequiresRoles.class, Login.class, Logout.class});
    }

    public void processAnnotationAdded(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState added) {
        ElementHandle.Package handle = metaModel.getHandle();
        if (key.getType().equals((Object)Name.create(Shiro.class))) {
            JSON json = new JSON();
            json.set("rememberMe", added.get((Object)"rememberMe"));
            json.set("config", added.get((Object)"config"));
            List realms = (List)added.get((Object)"realms");
            JSON realmsJSON = new JSON();
            if (realms != null) {
                for (AnnotationState sel : realms) {
                    ElementHandle.Type clazz = (ElementHandle.Type)sel.get((Object)"value");
                    String name = (String)sel.get((Object)"name");
                    realmsJSON.set(clazz.getName().toString(), (Object)new JSON().set("name", (Object)name));
                }
            }
            json.set("realms", (Object)realmsJSON);
            this.enableMap.put(handle, json);
        } else {
            this.emitConfig(key, added);
        }
    }

    private void emitConfig(AnnotationKey key, AnnotationState added) {
        if (key.getType().equals((Object)Name.create(RequiresGuest.class)) || key.getType().equals((Object)Name.create(RequiresUser.class)) || key.getType().equals((Object)Name.create(RequiresAuthentication.class)) || key.getType().equals((Object)Name.create(RequiresRoles.class)) || key.getType().equals((Object)Name.create(RequiresPermissions.class)) || key.getType().equals((Object)Name.create(Login.class)) || key.getType().equals((Object)Name.create(Logout.class))) {
            if (key.getElement() instanceof ElementHandle.Method) {
                Map<AnnotationKey, AnnotationState> annotations = this.methods.get(key.getElement());
                if (annotations == null) {
                    annotations = new HashMap<AnnotationKey, AnnotationState>();
                    this.methods.put(key.getElement(), annotations);
                }
                annotations.put(key, added);
            } else if (key.getElement() instanceof ElementHandle.Type) {
                if (key.getType().equals((Object)Name.create(RequiresGuest.class)) || key.getType().equals((Object)Name.create(RequiresAuthentication.class)) || key.getType().equals((Object)Name.create(RequiresUser.class))) {
                    Map<AnnotationKey, AnnotationState> annotations = this.controllers.get(key.getElement());
                    if (annotations == null) {
                        annotations = new HashMap<AnnotationKey, AnnotationState>();
                        this.controllers.put(key.getElement(), annotations);
                    }
                    annotations.put(key, added);
                } else {
                    throw new UnsupportedOperationException("Unsupported " + key.getType() + " at " + key.getElement());
                }
            }
        }
    }

    private void emitConfig(JSON json, AnnotationKey key, AnnotationState added) {
        if (key.getType().equals((Object)Name.create(Login.class))) {
            if (json.get("operator") != null) {
                throw new UnsupportedOperationException("Unsupported multiple operators at " + key.getElement());
            }
            json.set("operator", (Object)"login");
        } else if (key.getType().equals((Object)Name.create(Logout.class))) {
            if (json.get("operator") != null) {
                throw new UnsupportedOperationException("Unsupported multiple operators at " + key.getElement());
            }
            json.set("operator", (Object)"logout");
        } else if (key.getType().equals((Object)Name.create(RequiresGuest.class))) {
            if (json.get("require") != null || json.get("permissions") != null || json.get("roles") != null) {
                throw new UnsupportedOperationException("Unsupported multiple requirements at " + key.getElement());
            }
            json.set("require", (Object)"guest");
        } else if (key.getType().equals((Object)Name.create(RequiresUser.class))) {
            if (json.get("require") != null || json.get("permissions") != null || json.get("roles") != null) {
                throw new UnsupportedOperationException("Unsupported multiple requirements at " + key.getElement());
            }
            json.set("require", (Object)"user");
        } else if (key.getType().equals((Object)Name.create(RequiresAuthentication.class))) {
            if (json.get("require") != null || json.get("permissions") != null || json.get("roles") != null) {
                throw new UnsupportedOperationException("Unsupported multiple requirements at " + key.getElement());
            }
            json.set("require", (Object)"authenticate");
        } else if (key.getType().equals((Object)Name.create(RequiresPermissions.class))) {
            if (json.get("require") != null) {
                throw new UnsupportedOperationException("Unsupported multiple requirements at " + key.getElement());
            }
            ArrayList values = (ArrayList)added.get((Object)"value");
            String logical = (String)added.get((Object)"logical");
            JSON foo = new JSON();
            foo.set("value", (Object)values);
            if (logical != null) {
                foo.set("logical", (Object)logical);
            } else {
                foo.set("logical", (Object)Logical.AND);
            }
            json.set("permissions", (Object)foo);
        } else if (key.getType().equals((Object)Name.create(RequiresRoles.class))) {
            if (json.get("require") != null) {
                throw new UnsupportedOperationException("Unsupported multiple requirements at " + key.getElement());
            }
            ArrayList values = (ArrayList)added.get((Object)"value");
            String logical = (String)added.get((Object)"logical");
            JSON foo = new JSON();
            foo.set("value", (Object)values);
            if (logical != null) {
                foo.set("logical", (Object)logical);
            } else {
                foo.set("logical", (Object)Logical.AND);
            }
            json.set("roles", (Object)foo);
        }
    }

    public void postProcessEvents(ApplicationMetaModel metaModel) {
        ElementHandle.Package packageHandle = metaModel.getHandle();
        JSON config = this.enableMap.get(packageHandle);
        if (config != null) {
            ControllersMetaModel controllersModel = (ControllersMetaModel)metaModel.getChild(ControllersMetaModel.KEY);
            for (ControllerMetaModel controller : controllersModel) {
                Map<AnnotationKey, AnnotationState> annotations = this.controllers.get(controller.getHandle());
                if (annotations != null) {
                    JSON controllerJSON = new JSON();
                    config.set(controller.getHandle().getName().toString(), (Object)controllerJSON);
                    for (Map.Entry<AnnotationKey, AnnotationState> entry : annotations.entrySet()) {
                        AnnotationKey key = entry.getKey();
                        if (controllerJSON.get("require") != null) {
                            throw new UnsupportedOperationException("Unsupported multiple requirements at " + key.getElement());
                        }
                        if (key.getType().equals((Object)Name.create(RequiresGuest.class))) {
                            controllerJSON.set("require", (Object)"guest");
                            continue;
                        }
                        if (key.getType().equals((Object)Name.create(RequiresAuthentication.class))) {
                            controllerJSON.set("require", (Object)"authenticate");
                            continue;
                        }
                        if (!key.getType().equals((Object)Name.create(RequiresUser.class))) continue;
                        controllerJSON.set("require", (Object)"user");
                    }
                }
                for (HandlerMetaModel handler : controller) {
                    annotations = this.methods.get(handler.getMethod());
                    String methodId = handler.getMethod().getMethodHandle().toString();
                    if (annotations == null) continue;
                    JSON controllerJSON = config.getJSON(controller.getHandle().getName().toString());
                    if (controllerJSON == null) {
                        controllerJSON = new JSON();
                        config.set(controller.getHandle().getName().toString(), (Object)controllerJSON);
                    }
                    JSON methodJSON = new JSON();
                    for (Map.Entry<AnnotationKey, AnnotationState> entry : annotations.entrySet()) {
                        this.emitConfig(methodJSON, entry.getKey(), entry.getValue());
                    }
                    JSON methodsJSON = controllerJSON.getJSON("methods");
                    if (methodsJSON == null) {
                        methodsJSON = new JSON();
                        controllerJSON.set("methods", (Object)methodsJSON);
                    }
                    methodsJSON.set(methodId.substring(methodId.lastIndexOf(35) + 1), (Object)methodJSON);
                }
            }
        }
    }

    public void destroy(ApplicationMetaModel application) {
        this.enableMap.remove(application.getHandle());
    }

    public JSON getDescriptor(ApplicationMetaModel application) {
        return this.enableMap.get(application.getHandle());
    }
}

