/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.shiro.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.PostConstruct;
import juzu.Response;
import juzu.Scope;
import juzu.asset.AssetLocation;
import juzu.impl.common.JSON;
import juzu.impl.inject.Scoped;
import juzu.impl.plugin.ServiceContext;
import juzu.impl.plugin.ServiceDescriptor;
import juzu.impl.plugin.application.ApplicationService;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.impl.request.Stage;
import juzu.plugin.shiro.impl.SecurityManagerProvider;
import juzu.plugin.shiro.impl.ShiroDescriptor;
import juzu.plugin.shiro.impl.SubjectScoped;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.config.Ini;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;

public class ShiroService
extends ApplicationService
implements RequestFilter<Stage.Handler> {
    SecurityManager manager;
    private ShiroDescriptor descriptor;

    public ShiroService() {
        super("shiro");
    }

    public ServiceDescriptor init(ServiceContext context) throws Exception {
        return context.getConfig() != null ? (this.descriptor = new ShiroDescriptor(context)) : null;
    }

    @PostConstruct
    public void postConstruct() throws ConfigurationException, IOException {
        URL iniURL = this.getShiroIniURL();
        if (iniURL != null) {
            Ini ini = new Ini();
            ini.load(iniURL.openStream());
            IniSecurityManagerFactory factory = new IniSecurityManagerFactory(ini);
            this.manager = (SecurityManager)factory.getInstance();
        }
    }

    public Class<Stage.Handler> getStageType() {
        return Stage.Handler.class;
    }

    public Response handle(Stage.Handler stage) {
        if (this.descriptor != null) {
            try {
                SecurityManagerProvider provider;
                if (this.manager == null) {
                    provider = new SecurityManagerProvider(this.descriptor.getConfig());
                    this.manager = provider.get();
                }
                this.start();
                provider = this.descriptor.invoke(stage);
                return provider;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            finally {
                ThreadContext.unbindSubject();
                ThreadContext.unbindSecurityManager();
            }
        }
        return stage.invoke();
    }

    private void start() throws InvocationTargetException {
        Request request = Request.getCurrent();
        Subject currentUser = null;
        if (request.getScopeController().get(Scope.SESSION, (Object)"currentUser") != null) {
            currentUser = (Subject)request.getScopeController().get(Scope.SESSION, (Object)"currentUser").get();
        } else {
            Subject.Builder builder = new Subject.Builder(this.manager);
            currentUser = builder.buildSubject();
            SubjectScoped subjectValue = new SubjectScoped(currentUser);
            request.getScopeController().put(Scope.SESSION, (Object)"currentUser", (Scoped)subjectValue);
        }
        ThreadContext.bind((SecurityManager)this.manager);
        ThreadContext.bind((Subject)currentUser);
    }

    private URL getShiroIniURL() throws MalformedURLException {
        JSON json = this.descriptor.getConfig().getJSON("config");
        if (json == null) {
            return null;
        }
        AssetLocation location = AssetLocation.APPLICATION;
        if (json.get("location") != null) {
            location = AssetLocation.valueOf((String)json.getString("location"));
        }
        switch (location) {
            case APPLICATION: {
                return this.descriptor.getContext().getApplicationResolver().resolve(json.getString("value"));
            }
            case SERVER: {
                return this.descriptor.getContext().getServerResolver().resolve(json.getString("value"));
            }
            case URL: {
                return new URL(json.getString("value"));
            }
        }
        return null;
    }
}

