/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.upload.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import juzu.impl.plugin.PluginContext;
import juzu.impl.plugin.PluginDescriptor;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.request.ContextualParameter;
import juzu.impl.request.ControlParameter;
import juzu.impl.request.Method;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.request.ClientContext;
import juzu.request.RequestParameter;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;

public class UploadPlugin
extends ApplicationPlugin
implements RequestFilter {
    public UploadPlugin() {
        super("upload");
    }

    public PluginDescriptor init(PluginContext context) throws Exception {
        return new PluginDescriptor();
    }

    public void invoke(Request request) {
        String contentType;
        final ClientContext clientContext = request.getClientContext();
        if (clientContext != null && (contentType = clientContext.getContentType()) != null && contentType.startsWith("multipart/")) {
            RequestContext ctx = new RequestContext(){

                public String getCharacterEncoding() {
                    return clientContext.getCharacterEncoding();
                }

                public String getContentType() {
                    return clientContext.getContentType();
                }

                public int getContentLength() {
                    return clientContext.getContentLenth();
                }

                public InputStream getInputStream() throws IOException {
                    return clientContext.getInputStream();
                }
            };
            FileUpload upload = new FileUpload((FileItemFactory)new DiskFileItemFactory());
            try {
                List list = upload.parseRequest(ctx);
                HashMap parameters = new HashMap();
                for (FileItem file : list) {
                    RequestParameter parameter;
                    String name = file.getFieldName();
                    if (file.isFormField()) {
                        parameter = (RequestParameter)parameters.get(name);
                        parameter = parameter != null ? parameter.append(new String[]{file.getString()}) : RequestParameter.create((String)name, (String)file.getString());
                        parameter.appendTo(parameters);
                        continue;
                    }
                    parameter = request.getMethod().getParameter(name);
                    if (!(parameter instanceof ContextualParameter) || !FileItem.class.isAssignableFrom(parameter.getType())) continue;
                    request.setArgument((ControlParameter)parameter, (Object)file);
                }
                for (RequestParameter parameter : request.getParameters().values()) {
                    if (parameters.containsKey(parameter.getName())) continue;
                    parameter.appendTo(parameters);
                }
                Method method = request.getMethod();
                Map arguments = method.getArguments(parameters);
                for (Map.Entry argument : request.getArguments().entrySet()) {
                    if (!(argument.getKey() instanceof ContextualParameter)) continue;
                    arguments.put(argument.getKey(), argument.getValue());
                }
                request.setArguments(arguments);
            }
            catch (FileUploadException e) {
                throw new UndeclaredThrowableException(e);
            }
        }
        request.invoke();
    }
}

