/*
 * Decompiled with CFR 0.152.
 */
package juzu.plugin.validation.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.validation.ParameterNameProvider;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import juzu.Response;
import juzu.impl.plugin.controller.ControllerPlugin;
import juzu.impl.request.ControlParameter;
import juzu.impl.request.ControllerHandler;
import juzu.impl.request.RequestFilter;
import juzu.impl.request.Stage;
import juzu.plugin.validation.ValidationError;
import org.hibernate.validator.internal.util.CollectionHelper;

public class ValidationFilter
implements RequestFilter<Stage.Invoke>,
ParameterNameProvider {
    private Validator validator;
    private final ControllerPlugin controllerPlugin;

    @Inject
    public ValidationFilter(ControllerPlugin controllerPlugin) {
        this.controllerPlugin = controllerPlugin;
    }

    public Class<Stage.Invoke> getStageType() {
        return Stage.Invoke.class;
    }

    @PostConstruct
    public void start() {
        ValidatorFactory factory = Validation.byDefaultProvider().configure().parameterNameProvider((ParameterNameProvider)this).buildValidatorFactory();
        this.validator = factory.getValidator();
    }

    public Response handle(Stage.Invoke argument) {
        Set violations;
        if (this.validator != null && (violations = this.validator.forExecutables().validateParameters(argument.getController(), argument.getMethod(), argument.getArguments(), new Class[0])).size() > 0) {
            return new ValidationError(violations);
        }
        return argument.invoke();
    }

    public List<String> getParameterNames(Constructor<?> constructor) {
        return this.getParameterNames(constructor.getParameterTypes().length);
    }

    public List<String> getParameterNames(Method method) {
        ControllerHandler handler = this.controllerPlugin.getDescriptor().getHandler(method);
        if (handler != null) {
            List parameters = handler.getParameters();
            ArrayList<String> parameterNames = new ArrayList<String>(parameters.size());
            for (ControlParameter parameter : parameters) {
                parameterNames.add(parameter.getName());
            }
            return parameterNames;
        }
        return this.getParameterNames(method.getParameterTypes().length);
    }

    private List<String> getParameterNames(int parameterCount) {
        ArrayList parameterNames = CollectionHelper.newArrayList();
        for (int i = 0; i < parameterCount; ++i) {
            parameterNames.add(this.getPrefix() + i);
        }
        return parameterNames;
    }

    protected String getPrefix() {
        return "arg";
    }
}

