/*
 * Decompiled with CFR 0.152.
 */
package juzu;

import java.util.HashMap;
import java.util.Iterator;
import juzu.PropertyType;
import juzu.impl.common.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMap
implements Iterable<PropertyType<?>> {
    private static final Object[] NO_VALUES = new Object[0];
    private HashMap<PropertyType<?>, Values> map;
    private PropertyMap delegate;

    public PropertyMap() {
    }

    public PropertyMap(PropertyMap delegate) {
        this.delegate = delegate;
    }

    private <T> Values get(PropertyType<T> property, boolean recurse, boolean modifiable) {
        Values values = null;
        if (this.map != null) {
            values = this.map.get(property);
        }
        if (values == null && recurse && this.delegate != null) {
            values = this.delegate.get(property, true, false);
        }
        if (modifiable) {
            if (values == null) {
                if (this.map == null) {
                    this.map = new HashMap();
                }
                values = new Values(this);
                this.map.put(property, values);
            } else if (values.owner != this) {
                if (this.map == null) {
                    this.map = new HashMap();
                }
                values = new Values(this, values);
                this.map.put(property, values);
            }
        } else if (values != null && values.size == 0) {
            values = null;
        }
        return values;
    }

    @Override
    public Iterator<PropertyType<?>> iterator() {
        return this.map != null ? this.map.keySet().iterator() : Tools.emptyIterator();
    }

    public <T> T getValue(PropertyType<T> property) {
        T value = null;
        Values values = this.get(property, true, false);
        if (values != null && values.size > 0) {
            value = property.cast(values.objects[0]);
        }
        return value;
    }

    public <T> Iterable<T> getValues(PropertyType<T> property) throws NullPointerException {
        return this.get(property, true, false);
    }

    public <T> void setValue(PropertyType<T> property, T value) throws NullPointerException {
        if (value == null) {
            this.remove(property);
        } else {
            Values existing = this.get(property, false, true);
            existing.clear();
            existing.addValue(value);
        }
    }

    public <T> void setValues(PropertyType<T> property, T ... values) throws NullPointerException {
        Values existing = this.get(property, false, true);
        existing.clear();
        for (T value : values) {
            existing.addValue(value);
        }
    }

    public <T> void setValues(PropertyType<T> property, Iterable<? extends T> values) throws NullPointerException {
        Values existing = this.get(property, false, true);
        existing.clear();
        for (T value : values) {
            existing.addValue(value);
        }
    }

    public <T> void addValue(PropertyType<T> property, T value) throws NullPointerException {
        this.get(property, true, true).addValue(value);
    }

    public <T> void addValues(PropertyType<T> property, T ... values) throws NullPointerException {
        Values existing = this.get(property, true, true);
        for (T value : values) {
            existing.addValue(value);
        }
    }

    public <T> void addValues(PropertyType<T> property, Iterable<? extends T> values) throws NullPointerException {
        Values existing = this.get(property, true, true);
        for (T value : values) {
            existing.addValue(value);
        }
    }

    public <T> void remove(PropertyType<T> property) throws NullPointerException {
        Values values = this.get(property, false, this.delegate != null);
        if (values != null) {
            values.clear();
        }
    }

    public <T> boolean contains(PropertyType<T> property) throws NullPointerException {
        Values values = this.get(property, true, false);
        return values != null && values.size > 0;
    }

    static /* synthetic */ Object[] access$000() {
        return NO_VALUES;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Values
    implements Iterable<Object> {
        private Object[] objects = PropertyMap.access$000();
        private int size = 0;
        private final PropertyMap owner;

        private Values(PropertyMap owner) {
            this.owner = owner;
        }

        private Values(PropertyMap owner, Values that) {
            this.owner = owner;
            this.objects = (Object[])that.objects.clone();
            this.size = that.size;
        }

        @Override
        public Iterator<Object> iterator() {
            return Tools.iterator(0, this.size, this.objects);
        }

        void addValue(Object value) {
            if (this.size >= this.objects.length) {
                Object[] copy = new Object[this.size + 4];
                System.arraycopy(this.objects, 0, copy, 0, this.objects.length);
                this.objects = copy;
            }
            this.objects[this.size++] = value;
        }

        void clear() {
            if (this.size > 0) {
                for (int i = this.size - 1; i >= 0; --i) {
                    this.objects[i] = null;
                }
                this.size = 0;
            }
        }
    }
}

