/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.amd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import juzu.impl.plugin.amd.AMDDependency;
import juzu.impl.plugin.amd.Module;
import juzu.impl.plugin.amd.ModuleMetaData;
import juzu.impl.plugin.amd.NormalizeJSReader;

public class ModuleManager {
    protected final LinkedHashMap<String, Module> modules = new LinkedHashMap();
    protected final HashMap<String, URL> resources = new HashMap();

    public Module addAMD(ModuleMetaData data, URL url) throws NullPointerException, IllegalArgumentException, IOException {
        Module module;
        String name = data.getId();
        if (name == null) {
            name = "" + data.getPath().hashCode();
        }
        if ((module = this.modules.get(name)) == null) {
            module = new Module(name, data.getLocation(), data.getPath());
            this.modules.put(name, module);
            switch (data.getLocation()) {
                case APPLICATION: {
                    if (data instanceof ModuleMetaData.Require) {
                        this.resources.put(data.getPath(), url);
                        break;
                    }
                    this.resources.put(data.getPath(), new URL("amd", null, 0, "/", new AMDURLStreamHandler((ModuleMetaData.Define)data, url)));
                    break;
                }
                case SERVER: 
                case URL: {
                    if (!(data instanceof ModuleMetaData.Require)) break;
                    this.resources.put(data.getPath(), url);
                    break;
                }
            }
        }
        return module;
    }

    public URL resolveAsset(String path) {
        return this.resources.get(path);
    }

    private class AMDURLStreamHandler
    extends URLStreamHandler {
        private final byte[] data;

        public AMDURLStreamHandler(ModuleMetaData.Define data, URL url) throws IOException {
            StringBuilder sb = new StringBuilder();
            sb.append("\ndefine('").append(data.getId()).append("', [");
            this.joinDependencies(sb, data);
            sb.append("], function(");
            this.joinParams(sb, data);
            sb.append(") {\nvar require = Wrapper.require, requirejs = Wrapper.require,define = Wrapper.define;");
            sb.append("\nWrapper.define.names=[");
            this.joinDependencies(sb, data);
            sb.append("];");
            sb.append("\nWrapper.define.deps=[");
            this.joinParams(sb, data);
            sb.append("];");
            sb.append("\nreturn ");
            int idx = -1;
            String adapter = data.getAdapter();
            if (adapter != null && !adapter.isEmpty()) {
                idx = adapter.indexOf("@{include}");
            }
            if (idx != -1) {
                sb.append(adapter.substring(0, idx)).append("\n");
            }
            NormalizeJSReader reader = new NormalizeJSReader(new InputStreamReader(url.openStream()));
            char[] buffer = new char[512];
            while (true) {
                int i;
                if ((i = reader.read(buffer)) == 0) {
                    continue;
                }
                if (i == -1) break;
                sb.append(buffer, 0, i);
            }
            if (idx != -1) {
                sb.append(adapter.substring(idx + "@{include}".length(), adapter.length()));
            }
            sb.append("\n});");
            this.data = sb.toString().getBytes("UTF-8");
        }

        private void joinDependencies(StringBuilder sb, ModuleMetaData.Define data) {
            Iterator<AMDDependency> i = data.getDependencies().iterator();
            while (i.hasNext()) {
                AMDDependency dependency = i.next();
                sb.append("'").append(dependency.name).append("'");
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
        }

        private void joinParams(StringBuilder sb, ModuleMetaData.Define data) {
            Iterator<AMDDependency> i = data.getDependencies().iterator();
            while (i.hasNext()) {
                AMDDependency dependency = i.next();
                if (dependency.alias != null && !dependency.alias.isEmpty()) {
                    sb.append(dependency.alias);
                } else {
                    sb.append(dependency.name);
                }
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
        }

        protected URLConnection openConnection(URL u) throws IOException {
            return new URLConnection(u){

                public void connect() throws IOException {
                }

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(AMDURLStreamHandler.this.data);
                }
            };
        }
    }
}

