/*
 * Decompiled with CFR 0.152.
 */
package juzu.bridge.vertx;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import juzu.bridge.vertx.VertxWebBridge;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.BridgeConfig;
import juzu.impl.common.Content;
import juzu.impl.common.JSON;
import juzu.impl.common.Name;
import juzu.impl.common.RunMode;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.plugin.module.Module;
import juzu.impl.plugin.module.ModuleContext;
import juzu.impl.plugin.module.ModuleLifeCycle;
import juzu.impl.resource.ClassLoaderResolver;
import juzu.impl.resource.ResourceResolver;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.HttpServerResponse;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.deploy.Container;

public class Application {
    private final Container container;
    private final Vertx vertx;
    private final ClassLoader loader;
    private final DiskFileSystem sourcePath;
    private final Name main;
    private ModuleLifeCycle.Dynamic<File> lifeCycle;
    final int port;

    Application(Container container, Vertx vertx, ClassLoader loader, DiskFileSystem sourcePath, Name main, int port) {
        this.container = container;
        this.vertx = vertx;
        this.loader = loader;
        this.sourcePath = sourcePath;
        this.main = main;
        this.lifeCycle = null;
        this.port = port;
    }

    public void start() throws Exception {
        final juzu.impl.common.Logger log = new juzu.impl.common.Logger(){
            final Logger logger;
            {
                this.logger = Application.this.container.getLogger();
            }

            public void log(CharSequence msg) {
                this.logger.info((Object)msg);
            }

            public void log(CharSequence msg, Throwable t) {
                this.logger.info((Object)msg, t);
            }
        };
        this.lifeCycle = new ModuleLifeCycle.Dynamic(log, this.loader, (ReadFileSystem)this.sourcePath);
        this.lifeCycle.refresh(true);
        ClassLoaderResolver r = new ClassLoaderResolver(this.loader);
        Module module = new Module(new ModuleContext((ResourceResolver)r){
            final /* synthetic */ ResourceResolver val$r;
            {
                this.val$r = resourceResolver;
            }

            public ClassLoader getClassLoader() {
                return Application.this.loader;
            }

            public JSON getConfig() throws Exception {
                ReadFileSystem c = Application.this.lifeCycle.getClasses();
                Content f = (Content)c.getContent((Object)new String[]{"juzu", "config.json"}).getObject();
                return (JSON)JSON.parse((String)f.getCharSequence().toString());
            }

            public ResourceResolver getServerResolver() {
                return this.val$r;
            }

            public ReadFileSystem<?> getResourcePath() {
                throw new UnsupportedOperationException("?");
            }

            public ModuleLifeCycle<?> getLifeCycle() {
                return Application.this.lifeCycle;
            }

            public RunMode getRunMode() {
                return RunMode.DEV;
            }
        });
        HashMap<String, String> cfg = new HashMap<String, String>();
        cfg.put("juzu.inject", InjectorProvider.INJECT_GUICE.getValue());
        cfg.put("juzu.app_name", this.main.toString());
        BridgeConfig config = new BridgeConfig(cfg);
        config.injectImpl.bindBean(Vertx.class, null, (Object)this.vertx);
        final Bridge bridge = new Bridge(log, module, config, this.lifeCycle.getClasses(), null, (ResourceResolver)new ClassLoaderResolver(this.lifeCycle.getClassLoader()));
        HttpServer server = this.vertx.createHttpServer().requestHandler((Handler)new Handler<HttpServerRequest>(){
            juzu.impl.bridge.spi.web.Handler h;

            public void handle(final HttpServerRequest req) {
                try {
                    if (bridge.refresh(true)) {
                        this.h = null;
                    }
                    if (this.h == null) {
                        this.h = new juzu.impl.bridge.spi.web.Handler(bridge);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                HttpServerResponse response = req.response;
                URL assetURL = bridge.application.getScriptManager().resolveAsset(req.path);
                if (assetURL == null) {
                    assetURL = bridge.application.getStylesheetManager().resolveAsset(req.path);
                }
                boolean served = false;
                if (assetURL != null && "file".equals(assetURL.getProtocol())) {
                    try {
                        response.sendFile(new File(assetURL.toURI()).getAbsolutePath());
                        served = true;
                    }
                    catch (URISyntaxException ignore) {
                        // empty catch block
                    }
                }
                if (!served) {
                    String contentType = (String)req.headers().get("Content-Type");
                    if (contentType != null && contentType.startsWith("application/x-www-form-urlencoded")) {
                        req.bodyHandler((Handler)new Handler<Buffer>(){

                            public void handle(Buffer buffer) {
                                new VertxWebBridge(bridge, Application.this, req, buffer, log).handle(h);
                            }
                        });
                    } else {
                        new VertxWebBridge(bridge, Application.this, req, null, log).handle(this.h);
                    }
                }
            }
        }).listen(this.port);
    }

    public void stop() throws Exception {
        this.lifeCycle = null;
    }
}

