/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.router.metamodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import juzu.impl.common.JSON;
import juzu.impl.plugin.router.ParamDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteMetaModel
implements Serializable {
    HashMap<String, String> targets;
    ArrayList<RouteMetaModel> children;
    final String path;
    final Integer priority;
    HashMap<String, ParamDescriptor> parameters;

    public RouteMetaModel(String path, Integer priority) {
        this.path = path;
        this.priority = priority;
    }

    public String getPath() {
        return this.path;
    }

    RouteMetaModel setTarget(String key, String target) throws NullPointerException, IllegalArgumentException {
        if (key == null) {
            throw new NullPointerException("No null key accepted");
        }
        if (target == null) {
            if (this.targets != null) {
                this.targets.remove(key);
            }
        } else {
            if (this.targets == null) {
                this.targets = new HashMap();
            }
            if (this.targets.containsKey(key)) {
                throw new IllegalArgumentException("Cannot have two identical targets " + key);
            }
            this.targets.put(key, target);
        }
        return this;
    }

    String getTarget(String key) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("No null key accepted");
        }
        if (this.targets != null) {
            return this.targets.get(key);
        }
        return null;
    }

    RouteMetaModel addChild(int priority, String path, HashMap<String, ParamDescriptor> parameters) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        RouteMetaModel found = null;
        for (RouteMetaModel child : this.children) {
            if (!child.path.equals(path) || child.priority != priority) continue;
            found = child;
            break;
        }
        if (found == null) {
            found = new RouteMetaModel(path, priority);
            this.children.add(found);
        }
        if (parameters != null && parameters.size() > 0) {
            if (found.parameters == null) {
                found.parameters = new LinkedHashMap<String, ParamDescriptor>();
            }
            found.parameters.putAll(parameters);
        }
        return found;
    }

    public List<RouteMetaModel> getChildren() {
        return this.children;
    }

    public Map<String, String> getTargets() {
        return this.targets;
    }

    public Map<String, ParamDescriptor> getParameters() {
        return this.parameters;
    }

    public JSON toJSON() {
        JSON json = new JSON();
        if (this.path != null) {
            json.set("path", this.path);
        }
        if (this.targets != null && this.targets.size() > 0) {
            json.set("targets", this.targets);
        }
        if (this.parameters != null && this.parameters.size() > 0) {
            JSON b = new JSON();
            for (Map.Entry<String, ParamDescriptor> parameter : this.parameters.entrySet()) {
                ParamDescriptor value = parameter.getValue();
                b.set(parameter.getKey(), new JSON().set("pattern", value.getPattern()).set("preserve-path", value.getPreservePath()).set("capture-group", value.getCaptureGroup()));
            }
            json.set("parameters", b);
        }
        if (this.children != null && this.children.size() > 0) {
            RouteMetaModel[] routes = this.children.toArray(new RouteMetaModel[this.children.size()]);
            Arrays.sort(routes, new Comparator<RouteMetaModel>(){

                @Override
                public int compare(RouteMetaModel o1, RouteMetaModel o2) {
                    return o1.priority.compareTo(o2.priority);
                }
            });
            LinkedList<JSON> a = new LinkedList<JSON>();
            for (RouteMetaModel route : routes) {
                a.add(route.toJSON());
            }
            json.set("routes", a);
        }
        return json;
    }
}

