/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.parser;

import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.expression.ExpressionSupport;

public class EscapingExpression
extends ExpressionSupport {
    private final Expression base;

    public EscapingExpression(Expression base) {
        this.base = base;
    }

    public String getExpressionText() {
        return this.base.getExpressionText();
    }

    public Object evaluate(JellyContext context) {
        Object r = this.base.evaluate(context);
        if (r == null) {
            return null;
        }
        return this.escape(r.toString());
    }

    private String escape(String text) {
        int len = text.length();
        StringBuilder buf = new StringBuilder(len);
        boolean escaped = false;
        block4: for (int i = 0; i < len; ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    buf.append("&lt;");
                    escaped = true;
                    continue block4;
                }
                case '&': {
                    buf.append("&amp;");
                    escaped = true;
                    continue block4;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        if (!escaped) {
            return text;
        }
        return buf.toString();
    }
}

