/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.reactor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jvnet.hudson.reactor.Reactor;
import org.jvnet.hudson.reactor.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TaskBuilder {
    public static final TaskBuilder EMPTY_BUILDER = TaskBuilder.fromTasks(Collections.emptyList());

    public abstract Iterable<? extends Task> discoverTasks(Reactor var1) throws IOException;

    public static TaskBuilder fromTasks(final Collection<? extends Task> tasks) {
        return new TaskBuilder(){

            @Override
            public Iterable<? extends Task> discoverTasks(Reactor reactor) throws IOException {
                return tasks;
            }
        };
    }

    public static TaskBuilder union(final Iterable<? extends TaskBuilder> builders) {
        return new TaskBuilder(){

            @Override
            public Iterable<? extends Task> discoverTasks(Reactor reactor) throws IOException {
                ArrayList<Task> r = new ArrayList<Task>();
                for (TaskBuilder b : builders) {
                    for (Task task : b.discoverTasks(reactor)) {
                        r.add(task);
                    }
                }
                return r;
            }
        };
    }

    public static TaskBuilder union(TaskBuilder ... builders) {
        return TaskBuilder.union(Arrays.asList(builders));
    }
}

