/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jax_ws_commons.jaxws;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

abstract class AbstractJaxwsMojo
extends AbstractMojo {
    protected MavenProject project;
    protected boolean verbose;
    protected boolean keep;
    protected boolean extension;
    private String encoding;
    private List<String> args;
    private boolean xnocompile;
    private Map pluginArtifactMap;

    AbstractJaxwsMojo() {
    }

    protected abstract File getDestDir();

    protected abstract File getSourceDestDir();

    protected abstract void addSourceRoot(String var1);

    protected abstract File getDefaultSrcOut();

    protected String initClassLoader(ClassLoader parent) throws MojoExecutionException {
        try {
            List classpathFiles = this.project.getCompileClasspathElements();
            URL[] urls = new URL[classpathFiles.size() + 3];
            StringBuffer classPath = new StringBuffer();
            for (int i = 0; i < classpathFiles.size(); ++i) {
                this.getLog().debug((CharSequence)((String)classpathFiles.get(i)));
                urls[i] = new File((String)classpathFiles.get(i)).toURI().toURL();
                classPath.append((String)classpathFiles.get(i));
                classPath.append(File.pathSeparatorChar);
            }
            urls[classpathFiles.size()] = new File(this.project.getBuild().getOutputDirectory()).toURI().toURL();
            Artifact jaxwsToolsArtifact = (Artifact)this.pluginArtifactMap.get("com.sun.xml.ws:jaxws-tools");
            urls[classpathFiles.size() + 1] = jaxwsToolsArtifact.getFile().toURI().toURL();
            File toolsJar = new File(System.getProperty("java.home"), "../lib/tools.jar");
            if (!toolsJar.exists()) {
                toolsJar = new File(System.getProperty("java.home"), "lib/tools.jar");
            }
            urls[classpathFiles.size() + 2] = toolsJar.toURI().toURL();
            URLClassLoader cl = new URLClassLoader(urls, parent);
            Thread.currentThread().setContextClassLoader(cl);
            System.setProperty("java.class.path", classPath.toString());
            String sysCp = System.getProperty("java.class.path");
            return sysCp;
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected List<String> getCommonArgs() throws MojoExecutionException {
        ArrayList<String> commonArgs = new ArrayList<String>();
        if (!this.isDefaultSrc(this.getSourceDestDir()) || this.keep) {
            commonArgs.add("-keep");
            commonArgs.add("-s");
            commonArgs.add(this.getSourceDestDir().getAbsolutePath());
            this.getSourceDestDir().mkdirs();
            this.addSourceRoot(this.getSourceDestDir().getAbsolutePath());
        }
        File destDir = this.getDestDir();
        if (this.xnocompile && this.isDefaultOut(this.getDestDir())) {
            destDir = null;
        }
        if (destDir != null) {
            destDir.mkdirs();
            commonArgs.add("-d");
            commonArgs.add(destDir.getAbsolutePath());
        }
        if (this.verbose) {
            commonArgs.add("-verbose");
        }
        if (this.isArgSupported("-encoding")) {
            if (this.encoding != null) {
                commonArgs.add("-encoding");
                commonArgs.add(this.encoding);
            } else {
                this.getLog().warn((CharSequence)("Using platform encoding (" + System.getProperty("file.encoding") + "), build is platform dependent!"));
            }
        }
        if (this.extension) {
            commonArgs.add("-extension");
        }
        if (this.xnocompile) {
            commonArgs.add("-Xnocompile");
        }
        if (this.args != null) {
            for (String arg : this.args) {
                commonArgs.add(arg);
            }
        }
        return commonArgs;
    }

    protected boolean isArgSupported(String arg) throws MojoExecutionException {
        boolean isSupported = true;
        Artifact a = (Artifact)this.pluginArtifactMap.get("com.sun.xml.ws:jaxws-tools");
        String v = null;
        try {
            ArtifactVersion av = a.getSelectedVersion();
            v = av.toString();
            if ("-encoding".equals(arg)) {
                isSupported = av.getMajorVersion() >= 2 && av.getMinorVersion() >= 2 && av.getIncrementalVersion() >= 6;
            }
        }
        catch (OverConstrainedVersionException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
        if (!isSupported) {
            this.getLog().warn((CharSequence)("'" + arg + "' is not supported by jaxws-tools:" + v));
        }
        return isSupported;
    }

    private boolean isDefaultOut(File wsout) {
        Build b = this.project.getBuild();
        String out = b.getOutputDirectory();
        String testOut = b.getTestOutputDirectory();
        return wsout.equals(new File(out)) || wsout.equals(new File(testOut));
    }

    private boolean isDefaultSrc(File srcout) {
        return srcout.equals(this.getDefaultSrcOut());
    }
}

