/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.maven;

import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class OptionsConfiguration {
    private final String encoding;
    private final String schemaLanguage;
    private List<InputSource> grammars;
    private List<InputSource> bindFiles;
    private final EntityResolver entityResolver;
    private final String generatePackage;
    private final File generateDirectory;
    private final boolean readOnly;
    private final boolean packageLevelAnnotations;
    private final boolean noFileHeader;
    private final boolean enableIntrospection;
    private final boolean disableXmlSecurity;
    private final String accessExternalSchema;
    private final String accessExternalDTD;
    private final boolean enableExternalEntityProcessing;
    private final boolean contentForWildcard;
    private final boolean extension;
    private final boolean strict;
    private final boolean verbose;
    private final boolean debugMode;
    private final List<String> arguments;
    private final List<URL> plugins;
    private final String specVersion;

    public OptionsConfiguration(String encoding, String schemaLanguage, List<InputSource> grammars, List<InputSource> bindFiles, EntityResolver entityResolver, String generatePackage, File generateDirectory, boolean readOnly, boolean packageLevelAnnotations, boolean noFileHeader, boolean enableIntrospection, boolean disableXmlSecurity, String accessExternalSchema, String accessExternalDTD, boolean enableExternalEntityProcessing, boolean contentForWildcard, boolean extension, boolean strict, boolean verbose, boolean debugMode, List<String> arguments, List<URL> plugins, String specVersion) {
        this.encoding = encoding;
        this.schemaLanguage = schemaLanguage;
        this.grammars = grammars;
        this.bindFiles = bindFiles;
        this.entityResolver = entityResolver;
        this.generatePackage = generatePackage;
        this.generateDirectory = generateDirectory;
        this.readOnly = readOnly;
        this.packageLevelAnnotations = packageLevelAnnotations;
        this.noFileHeader = noFileHeader;
        this.enableIntrospection = enableIntrospection;
        this.disableXmlSecurity = disableXmlSecurity;
        this.accessExternalSchema = accessExternalSchema;
        this.accessExternalDTD = accessExternalDTD;
        this.enableExternalEntityProcessing = enableExternalEntityProcessing;
        this.contentForWildcard = contentForWildcard;
        this.extension = extension;
        this.strict = strict;
        this.verbose = verbose;
        this.debugMode = debugMode;
        this.arguments = arguments;
        this.plugins = plugins;
        this.specVersion = specVersion;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public List<InputSource> getGrammars() {
        return this.grammars;
    }

    public List<InputSource> getBindFiles() {
        return this.bindFiles;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public String getGeneratePackage() {
        return this.generatePackage;
    }

    public File getGenerateDirectory() {
        return this.generateDirectory;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isPackageLevelAnnotations() {
        return this.packageLevelAnnotations;
    }

    public boolean isNoFileHeader() {
        return this.noFileHeader;
    }

    public boolean isEnableIntrospection() {
        return this.enableIntrospection;
    }

    public boolean isDisableXmlSecurity() {
        return this.disableXmlSecurity;
    }

    public String getAccessExternalSchema() {
        return this.accessExternalSchema;
    }

    public String getAccessExternalDTD() {
        return this.accessExternalDTD;
    }

    public boolean isEnableExternalEntityProcessing() {
        return this.enableExternalEntityProcessing;
    }

    public boolean isContentForWildcard() {
        return this.contentForWildcard;
    }

    public boolean isExtension() {
        return this.extension;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public List<URL> getPlugins() {
        return this.plugins;
    }

    public String toString() {
        return MessageFormat.format("OptionsConfiguration [specVersion={0}\n generateDirectory={1}\n generatePackage={2}\n schemaLanguage={3}\n grammars.systemIds={4}\n bindFiles.systemIds={5}\n plugins={6}\n readOnly={7}\n packageLevelAnnotations={8}\n noFileHeader={9}\n enableIntrospection={10}\n disableXmlSecurity={11}\n accessExternalSchema={12}\n accessExternalDTD={13}\n contentForWildcard={14}\n extension={15}\n strict={16}\n verbose={17}\n debugMode={18}\n arguments={19}]", this.specVersion, this.generateDirectory, this.generatePackage, this.schemaLanguage, this.getSystemIds(this.grammars), this.getSystemIds(this.bindFiles), this.plugins, this.readOnly, this.packageLevelAnnotations, this.noFileHeader, this.enableIntrospection, this.disableXmlSecurity, this.accessExternalSchema, this.accessExternalDTD, this.contentForWildcard, this.extension, this.strict, this.verbose, this.debugMode, this.arguments);
    }

    private List<String> getSystemIds(List<InputSource> inputSources) {
        if (inputSources == null) {
            return null;
        }
        ArrayList<String> systemIds = new ArrayList<String>(inputSources.size());
        for (InputSource inputSource : inputSources) {
            systemIds.add(inputSource == null ? null : inputSource.getSystemId());
        }
        return systemIds;
    }
}

