/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.maven.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.codehaus.plexus.util.AbstractScanner;

public class JarScanner
extends AbstractScanner {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private File destinationDir = new File("/tmp");
    protected File file;
    protected ArrayList<String> filesIncluded;
    protected ArrayList<String> filesExcluded;

    public void scan() {
        if (this.file == null) {
            throw new IllegalStateException("No file set");
        }
        if (!this.file.exists()) {
            throw new IllegalStateException("File " + String.valueOf(this.file) + " does not exist");
        }
        if (this.file.isDirectory()) {
            throw new IllegalStateException("File " + String.valueOf(this.file) + " is a directory");
        }
        this.setupDefaultFilters();
        this.setupMatchPatterns();
        this.filesIncluded = new ArrayList();
        this.filesExcluded = new ArrayList();
        try (JarFile jarFile = new JarFile(this.file);){
            Enumeration<JarEntry> jarFileEntries = jarFile.entries();
            while (jarFileEntries.hasMoreElements()) {
                JarEntry entry = jarFileEntries.nextElement();
                String name = entry.getName();
                Path destinationPath = this.destinationDir.toPath().resolve(name).normalize();
                if (name != null && name.startsWith("..") || !destinationPath.startsWith(this.destinationDir.toPath())) {
                    throw new IOException("Bad zip entry for " + entry.getName());
                }
                char[][] tokenizedName = JarScanner.tokenizePathToCharArray(name, File.separator);
                if (name.endsWith("/")) continue;
                if (this.isIncluded(name, tokenizedName)) {
                    if (!this.isExcluded(name, tokenizedName)) {
                        this.filesIncluded.add(name);
                        continue;
                    }
                    this.filesExcluded.add(name);
                    continue;
                }
                this.filesExcluded.add(name);
            }
        }
        catch (IOException ioex) {
            throw new IllegalStateException("Unable to read the artifact JAR file [" + this.file.getAbsolutePath() + "].", ioex);
        }
    }

    public String[] getIncludedFiles() {
        return this.filesIncluded.toArray(EMPTY_STRING_ARRAY);
    }

    public List<URI> getIncludedURIs() throws URISyntaxException {
        ArrayList<URI> uris = new ArrayList<URI>(this.filesIncluded.size());
        for (String include : this.filesIncluded) {
            uris.add(new URI("jar:" + String.valueOf(this.file.toURI()) + "!/" + include));
        }
        return uris;
    }

    public String[] getFilesExcluded() {
        return this.filesExcluded.toArray(EMPTY_STRING_ARRAY);
    }

    public String[] getIncludedDirectories() {
        throw new IllegalStateException("JarScanner does not allow to return includedDirectories");
    }

    public File getBasedir() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    static String[] tokenizePathToString(String path, String separator) {
        ArrayList<String> ret = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(path, separator);
        while (st.hasMoreTokens()) {
            ret.add(st.nextToken());
        }
        return ret.toArray(new String[0]);
    }

    static char[][] tokenizePathToCharArray(String path, String separator) {
        String[] tokenizedName = JarScanner.tokenizePathToString(path, separator);
        char[][] tokenizedNameChar = new char[tokenizedName.length][];
        for (int i = 0; i < tokenizedName.length; ++i) {
            tokenizedNameChar[i] = tokenizedName[i].toCharArray();
        }
        return tokenizedNameChar;
    }
}

