/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jxc.apt;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.MirroredTypesException;
import com.sun.mirror.type.TypeMirror;
import com.sun.xml.bind.v2.model.annotation.AbstractInlineAnnotationReaderImpl;
import com.sun.xml.bind.v2.model.annotation.Locatable;
import com.sun.xml.bind.v2.model.annotation.LocatableAnnotation;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InlineAnnotationReaderImpl
extends AbstractInlineAnnotationReaderImpl<TypeMirror, TypeDeclaration, FieldDeclaration, MethodDeclaration> {
    public static final InlineAnnotationReaderImpl theInstance = new InlineAnnotationReaderImpl();
    private static final Annotation[] EMPTY_ANNOTATION = new Annotation[0];

    private InlineAnnotationReaderImpl() {
    }

    public <A extends Annotation> A getClassAnnotation(Class<A> a, TypeDeclaration clazz, Locatable srcPos) {
        return (A)LocatableAnnotation.create((Annotation)clazz.getAnnotation(a), (Locatable)srcPos);
    }

    public <A extends Annotation> A getFieldAnnotation(Class<A> a, FieldDeclaration f, Locatable srcPos) {
        return (A)LocatableAnnotation.create((Annotation)f.getAnnotation(a), (Locatable)srcPos);
    }

    public boolean hasFieldAnnotation(Class<? extends Annotation> annotationType, FieldDeclaration f) {
        return f.getAnnotation(annotationType) != null;
    }

    public boolean hasClassAnnotation(TypeDeclaration clazz, Class<? extends Annotation> annotationType) {
        return clazz.getAnnotation(annotationType) != null;
    }

    public Annotation[] getAllFieldAnnotations(FieldDeclaration field, Locatable srcPos) {
        return this.getAllAnnotations((Declaration)field, srcPos);
    }

    public <A extends Annotation> A getMethodAnnotation(Class<A> a, MethodDeclaration method, Locatable srcPos) {
        return (A)LocatableAnnotation.create((Annotation)method.getAnnotation(a), (Locatable)srcPos);
    }

    public boolean hasMethodAnnotation(Class<? extends Annotation> a, MethodDeclaration method) {
        return method.getAnnotation(a) != null;
    }

    public Annotation[] getAllMethodAnnotations(MethodDeclaration method, Locatable srcPos) {
        return this.getAllAnnotations((Declaration)method, srcPos);
    }

    private Annotation[] getAllAnnotations(Declaration decl, Locatable srcPos) {
        ArrayList<Annotation> r = new ArrayList<Annotation>();
        for (AnnotationMirror m : decl.getAnnotationMirrors()) {
            try {
                String fullName = m.getAnnotationType().getDeclaration().getQualifiedName();
                Class<Annotation> type = ((Object)((Object)this)).getClass().getClassLoader().loadClass(fullName).asSubclass(Annotation.class);
                Annotation annotation = decl.getAnnotation(type);
                if (annotation == null) continue;
                r.add(LocatableAnnotation.create((Annotation)annotation, (Locatable)srcPos));
            }
            catch (ClassNotFoundException e) {}
        }
        return r.toArray(EMPTY_ANNOTATION);
    }

    public <A extends Annotation> A getMethodParameterAnnotation(Class<A> a, MethodDeclaration m, int paramIndex, Locatable srcPos) {
        ParameterDeclaration[] params = m.getParameters().toArray(new ParameterDeclaration[0]);
        return (A)LocatableAnnotation.create((Annotation)params[paramIndex].getAnnotation(a), (Locatable)srcPos);
    }

    public <A extends Annotation> A getPackageAnnotation(Class<A> a, TypeDeclaration clazz, Locatable srcPos) {
        return (A)LocatableAnnotation.create((Annotation)clazz.getPackage().getAnnotation(a), (Locatable)srcPos);
    }

    public TypeMirror getClassValue(Annotation a, String name) {
        try {
            a.annotationType().getMethod(name, new Class[0]).invoke((Object)a, new Object[0]);
            assert (false);
            throw new IllegalStateException("should throw a MirroredTypeException");
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof MirroredTypeException) {
                MirroredTypeException me = (MirroredTypeException)e.getCause();
                return me.getTypeMirror();
            }
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }

    public TypeMirror[] getClassArrayValue(Annotation a, String name) {
        try {
            a.annotationType().getMethod(name, new Class[0]).invoke((Object)a, new Object[0]);
            assert (false);
            throw new IllegalStateException("should throw a MirroredTypesException");
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof MirroredTypesException) {
                MirroredTypesException me = (MirroredTypesException)e.getCause();
                Collection r = me.getTypeMirrors();
                return r.toArray(new TypeMirror[r.size()]);
            }
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }

    protected String fullName(MethodDeclaration m) {
        return m.getDeclaringType().getQualifiedName() + '#' + m.getSimpleName();
    }
}

