/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.value_constructor;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueConstructorPlugin
extends Plugin {
    public String getOptionName() {
        return "Xvalue-constructor";
    }

    public String getUsage() {
        return "  -Xvalue-constructor        :  enable generation of value constructors";
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        for (ClassOutline classOutline : outline.getClasses()) {
            JDefinedClass implClass = classOutline.implClass;
            JMethod defaultConstructor = implClass.constructor(1);
            defaultConstructor.javadoc().add((Object)"Default no-arg constructor");
            defaultConstructor.body().invoke("super");
            Collection<JFieldVar> superClassInstanceFields = this.getInstanceFields(this.getSuperclassFields(implClass));
            Collection<JFieldVar> thisClassInstanceFields = this.getInstanceFields(implClass.fields().values());
            boolean doGenerateValueConstructor = !superClassInstanceFields.isEmpty() || !thisClassInstanceFields.isEmpty();
            if (!doGenerateValueConstructor) continue;
            JMethod valueConstructor = implClass.constructor(1);
            valueConstructor.javadoc().add((Object)"Fully-initialising value constructor");
            if (implClass._extends() instanceof JDefinedClass) {
                JInvocation superInvocation = valueConstructor.body().invoke("super");
                for (JFieldVar superClassField : superClassInstanceFields) {
                    if (!this.generateConstructorParameter(superClassField)) continue;
                    JVar arg = valueConstructor.param(8, superClassField.type(), superClassField.name());
                    superInvocation.arg((JExpression)arg);
                }
            }
            for (JFieldVar field : thisClassInstanceFields) {
                if (!this.generateConstructorParameter(field)) continue;
                JVar arg = valueConstructor.param(8, field.type(), field.name());
                valueConstructor.body().assign((JAssignmentTarget)JExpr.refthis((String)field.name()), (JExpression)arg);
            }
        }
        return true;
    }

    protected Collection<JFieldVar> getInstanceFields(Collection<JFieldVar> fields) {
        ArrayList<JFieldVar> instanceFields = new ArrayList<JFieldVar>();
        for (JFieldVar fieldVar : fields) {
            boolean isStaticField = (fieldVar.mods().getValue() & 0x10) != 0;
            if (isStaticField) continue;
            instanceFields.add(fieldVar);
        }
        return instanceFields;
    }

    protected boolean generateConstructorParameter(JFieldVar field) {
        boolean isStaticField = (field.mods().getValue() & 0x10) > 0;
        return !isStaticField;
    }

    protected List<JFieldVar> getSuperclassFields(JDefinedClass implClass) {
        LinkedList<JFieldVar> fieldList = new LinkedList<JFieldVar>();
        JClass superclass = implClass._extends();
        while (superclass instanceof JDefinedClass) {
            fieldList.addAll(0, ((JDefinedClass)superclass).fields().values());
            superclass = superclass._extends();
        }
        return fieldList;
    }
}

