/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbcommons.i18n.addon.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class PropertyUtils {
    public static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static Map toLowerCase(Map draftMap, Locale locale) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Iterator iterator = draftMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            map.put(key.toLowerCase(), value);
        }
        return map;
    }

    public static Map load(InputStream is) throws IOException {
        Properties properties = new Properties();
        properties.load(is);
        return PropertyUtils.toMap(properties);
    }

    public static Map toMap(Properties properties) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Iterator iterator = ((Hashtable)properties).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            map.put(key, value);
        }
        return map;
    }

    public static void store(Map properties, OutputStream out, String comments) throws IOException {
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (comments != null) {
            PropertyUtils.writeln(awriter, "#" + comments);
        }
        PropertyUtils.writeln(awriter, "#" + new Date().toString());
        Iterator iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = (String)properties.get(key);
            PropertyUtils.writeln(awriter, PropertyUtils.escape(key, true) + "=" + PropertyUtils.escape(value, false));
        }
        awriter.flush();
    }

    public static String escape(String theString, boolean escapeSpace) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(PropertyUtils.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(PropertyUtils.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(PropertyUtils.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(PropertyUtils.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    public static char toHex(int nibble) {
        return HEX_DIGITS[nibble & 0xF];
    }
}

