/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbcommons.util;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JResourceFile;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.fmt.JPropertyFile;
import com.sun.tools.xjc.generator.ClassContext;
import com.sun.tools.xjc.grammar.ClassItem;
import java.util.Iterator;

public class CodeModelUtils {
    private CodeModelUtils() {
    }

    public static JPropertyFile getOrCreatePropertyFile(JPackage thePackage, String name) {
        JPropertyFile propertyFile = null;
        Iterator iterator = thePackage.propertyFiles();
        while (iterator.hasNext() && null == propertyFile) {
            JResourceFile resourceFile = (JResourceFile)iterator.next();
            if (!(resourceFile instanceof JPropertyFile) || !name.equals(resourceFile.name())) continue;
            propertyFile = (JPropertyFile)resourceFile;
        }
        if (null == propertyFile) {
            propertyFile = new JPropertyFile(name);
            thePackage.addResourceFile((JResourceFile)propertyFile);
        }
        return propertyFile;
    }

    public static String getClassName(JDefinedClass theClass) {
        return theClass.outer() == null ? theClass.fullName() : CodeModelUtils.getClassName((JDefinedClass)theClass.outer()) + "$" + theClass.name();
    }

    public static String getLocalClassName(JDefinedClass theClass) {
        return theClass.outer() == null ? theClass.name() : CodeModelUtils.getLocalClassName((JDefinedClass)theClass.outer()) + "$" + theClass.name();
    }

    public static String getPackagedClassName(JDefinedClass theClass) {
        if (theClass.outer() == null) {
            return theClass._package().name() + "." + theClass.name();
        }
        JDefinedClass outer = (JDefinedClass)theClass.outer();
        return CodeModelUtils.getPackagedClassName(outer) + "." + theClass.name();
    }

    public static String getFQCN(JDefinedClass theClass, boolean dotted) {
        if (theClass.outer() == null) {
            return theClass._package().name() + "." + theClass.name();
        }
        JDefinedClass outer = (JDefinedClass)theClass.outer();
        return CodeModelUtils.getFQCN(outer, dotted) + (dotted ? (char)'.' : '$') + theClass.name();
    }

    public static String getLCN(JDefinedClass theClass, boolean dotted) {
        if (theClass.outer() == null) {
            return theClass.name();
        }
        JDefinedClass outer = (JDefinedClass)theClass.outer();
        return CodeModelUtils.getLCN(outer, dotted) + (dotted ? (char)'.' : '$') + theClass.name();
    }

    public static JClass box(JType t) {
        if (t instanceof JClass) {
            return (JClass)t;
        }
        return ((JPrimitiveType)t).getWrapperClass();
    }

    public static JDefinedClass getOrCreateClass(JClassContainer container, int flags, String name) {
        try {
            return container._class(flags, name);
        }
        catch (JClassAlreadyExistsException jcaeex) {
            return jcaeex.getExistingClass();
        }
    }

    public static JDefinedClass getOrCreateClass(JCodeModel codeModel, int flags, String fullClassName) {
        String className;
        String packageName;
        int lastDotIndex = fullClassName.lastIndexOf(46);
        if (lastDotIndex >= 0) {
            packageName = fullClassName.substring(0, lastDotIndex);
            className = fullClassName.substring(lastDotIndex + 1);
        } else {
            packageName = null;
            className = fullClassName;
        }
        JPackage thePackage = packageName == null ? codeModel.rootPackage() : codeModel._package(packageName);
        return CodeModelUtils.getOrCreateClass((JClassContainer)thePackage, flags, className);
    }

    public static JStatement split(JDefinedClass theClass, JStatement[] statements, String prefix, int start, int length, int threshold) {
        JMethod method = theClass.method(20, (JType)theClass.owner().VOID, prefix);
        if (length < threshold) {
            int index = start;
            while (index - start < length) {
                JStatement statement = statements[index];
                method.body().add(statement);
                ++index;
            }
        } else {
            method.body().add(CodeModelUtils.split(theClass, statements, prefix + "_0", start, length / 2, threshold));
            method.body().add(CodeModelUtils.split(theClass, statements, prefix + "_1", start + length / 2, length - length / 2, threshold));
        }
        return JExpr.invoke((JMethod)method);
    }

    public static JMethod getMethod(JDefinedClass theClass, String name, JType[] arguments) {
        JMethod method = theClass.getMethod(name, arguments);
        if (method != null) {
            return method;
        }
        JClass draftSuperClass = theClass._extends();
        if (draftSuperClass == null || !(draftSuperClass instanceof JDefinedClass)) {
            return null;
        }
        JDefinedClass superClass = (JDefinedClass)draftSuperClass;
        return CodeModelUtils.getMethod(superClass, name, arguments);
    }

    public static JMethod getMethod(JDefinedClass theClass, String name) {
        Iterator iterator = theClass.methods();
        while (iterator.hasNext()) {
            JMethod method = (JMethod)iterator.next();
            if (!method.name().equals(name)) continue;
            return method;
        }
        return null;
    }

    public static JMethod getMethod(ClassContext classContext, String name) {
        JDefinedClass ref = classContext.ref;
        JMethod method = CodeModelUtils.getMethod(ref, name);
        if (method != null) {
            return method;
        }
        ClassItem superClassItem = classContext.target.getSuperClass();
        if (superClassItem == null) {
            return null;
        }
        ClassContext superClassContext = classContext.parent.getClassContext(superClassItem);
        return CodeModelUtils.getMethod(superClassContext, name);
    }

    public static JCodeModel getCodeModel(ClassContext classContext) {
        return classContext.ref.owner();
    }
}

