/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbcommons.util;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.msv.datatype.DatabindableDatatype;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionVisitor;
import com.sun.tools.xjc.generator.ClassContext;
import com.sun.tools.xjc.generator.GeneratorContext;
import com.sun.tools.xjc.generator.field.DefaultFieldRendererFactory;
import com.sun.tools.xjc.generator.field.FieldRenderer;
import com.sun.tools.xjc.grammar.AnnotatedGrammar;
import com.sun.tools.xjc.grammar.ClassItem;
import com.sun.tools.xjc.grammar.FieldItem;
import com.sun.tools.xjc.grammar.FieldUse;
import com.sun.tools.xjc.grammar.PrimitiveItem;
import com.sun.tools.xjc.grammar.TypeItem;
import com.sun.tools.xjc.grammar.util.Multiplicity;
import com.sun.tools.xjc.grammar.xducer.BuiltinDatatypeTransducerFactory;
import com.sun.tools.xjc.grammar.xducer.Transducer;
import java.beans.Introspector;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jvnet.jaxbcommons.util.AccessorUtils;
import org.jvnet.jaxbcommons.util.ClassUtils;
import org.jvnet.jaxbcommons.util.TypeUtils;
import org.jvnet.jaxbcommons.visitor.FieldGatheringVisitor;

public class FieldUtils {
    private FieldUtils() {
    }

    public static String getFQFN(ClassContext classContext, FieldItem fieldItem, boolean dotted) {
        return ClassUtils.getFQCN(classContext, dotted) + "." + fieldItem.name;
    }

    public static String getLFN(ClassContext classContext, FieldItem fieldItem, boolean dotted) {
        return ClassUtils.getLCN(classContext, dotted) + "." + fieldItem.name;
    }

    public static FieldItem[] getFieldItems(ClassContext classContext) {
        List fieldItems = (List)classContext.target.visit((ExpressionVisitor)new FieldGatheringVisitor(classContext));
        return fieldItems.toArray(new FieldItem[fieldItems.size()]);
    }

    public static String getFieldName(ClassContext classContext, FieldItem fieldItem) {
        return ClassUtils.getClassName(classContext.target) + "." + fieldItem.name;
    }

    public static String getPackagedFieldName(ClassContext classContext, FieldItem fieldItem) {
        return ClassUtils.getPackagedClassName(classContext) + "." + fieldItem.name;
    }

    public static String getFieldPropertyName(FieldItem fieldItem) {
        return fieldItem.name;
    }

    public static String getCommonFieldPropertyName(FieldItem fieldItem) {
        String draftName = fieldItem.name;
        return Introspector.decapitalize(draftName);
    }

    public static FieldItem getFieldItem(FieldUse fieldUse) {
        if (fieldUse.items.isEmpty()) {
            return null;
        }
        return (FieldItem)fieldUse.items.iterator().next();
    }

    public static FieldUse getFieldUse(ClassContext classContext, FieldItem fieldItem) {
        return classContext.target.getField(fieldItem.name);
    }

    public static String generateUniqueFieldName(JDefinedClass theClass, String prefix) {
        String name;
        if (null == FieldUtils.getField(theClass, prefix)) {
            name = prefix;
        } else {
            int index = 0;
            while (null != FieldUtils.getField(theClass, prefix + index)) {
                ++index;
            }
            name = prefix + index;
        }
        return name;
    }

    public static JVar getField(JDefinedClass theClass, String name) {
        JFieldVar result = null;
        Iterator iterator = theClass.fields();
        while (iterator.hasNext()) {
            JFieldVar var = (JFieldVar)iterator.next();
            if (!name.equals(var.name())) continue;
            result = var;
        }
        return result;
    }

    public static FieldItem createPrimitiveFieldItem(ClassContext classContext, String name, XSDatatype datatype, JType type) {
        GeneratorContext generatorContext = classContext.parent;
        AnnotatedGrammar grammar = generatorContext.getGrammar();
        JCodeModel codeModel = grammar.codeModel;
        ClassItem classItem = classContext.target;
        Expression dataExp = grammar.getPool().createData(datatype);
        Transducer transducer = BuiltinDatatypeTransducerFactory.get((AnnotatedGrammar)grammar, (XSDatatype)datatype);
        PrimitiveItem typeItem = grammar.createPrimitiveItem(transducer, (DatabindableDatatype)datatype, dataExp, null);
        FieldItem fieldItem = new FieldItem(name, (Expression)typeItem, null);
        try {
            fieldItem.addType((TypeItem)typeItem);
        }
        catch (FieldItem.BadTypeException btex) {
            // empty catch block
        }
        FieldUse fieldUse = classItem.getOrCreateFieldUse(name);
        fieldUse.items.add(fieldItem);
        fieldUse.multiplicity = Multiplicity.one;
        fieldUse.type = type;
        FieldRenderer fieldRenderer = new DefaultFieldRendererFactory(codeModel).create(generatorContext.getClassContext(classItem), fieldUse);
        fieldRenderer.generate();
        return fieldItem;
    }

    public static boolean isConstantField(ClassContext classContext, FieldItem fieldItem) {
        return AccessorUtils.get(classContext, fieldItem) == null;
    }

    public static FieldUse[] getFieldUses(ClassItem classItem) {
        if (classItem.getSuperClass() == null) {
            return classItem.getDeclaredFieldUses();
        }
        FieldUse[] superFieldUses = FieldUtils.getFieldUses(classItem.getSuperClass());
        FieldUse[] declaredFieldUses = classItem.getDeclaredFieldUses();
        FieldUse[] fieldUses = new FieldUse[superFieldUses.length + declaredFieldUses.length];
        System.arraycopy(superFieldUses, 0, fieldUses, 0, superFieldUses.length);
        System.arraycopy(declaredFieldUses, 0, fieldUses, superFieldUses.length, declaredFieldUses.length);
        return fieldUses;
    }

    public static boolean isEnumField(ClassContext classContext, FieldItem fieldItem) {
        TypeItem typeItem = TypeUtils.getCommonBaseTypeItem(classContext, fieldItem);
        if (typeItem instanceof PrimitiveItem) {
            PrimitiveItem primitiveTypeItem = (PrimitiveItem)typeItem;
            JType type = primitiveTypeItem.getType();
            if (type instanceof JDefinedClass) {
                JDefinedClass theClass = (JDefinedClass)type;
                return true;
            }
            return false;
        }
        return false;
    }

    public static FieldUse[] getAllFieldUses(ClassContext classContext) {
        return FieldUtils.getAllFieldUses(classContext.target);
    }

    public static FieldUse[] getAllFieldUses(ClassItem classItem) {
        LinkedList fieldUses = new LinkedList();
        FieldUtils.addAllFieldUses(classItem, fieldUses);
        return fieldUses.toArray(new FieldUse[fieldUses.size()]);
    }

    public static void addAllFieldUses(ClassItem classItem, List fieldUses) {
        FieldUse[] declaredFieldUses = classItem.getDeclaredFieldUses();
        for (int index = 0; index < declaredFieldUses.length; ++index) {
            FieldUse fieldUse = declaredFieldUses[index];
            fieldUses.add(fieldUse);
        }
        if (classItem.getSuperClass() != null) {
            FieldUtils.addAllFieldUses(classItem.getSuperClass(), fieldUses);
        }
    }
}

