/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbcommons.locator;

import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jvnet.jaxbcommons.locator.ObjectLocator;
import org.w3c.dom.Node;

public abstract class AbstractObjectLocator
implements ObjectLocator {
    protected final ObjectLocator parentLocator;
    protected final Object object;

    public AbstractObjectLocator(ObjectLocator parentLocator, Object object) {
        this.object = object;
        this.parentLocator = parentLocator;
    }

    public ObjectLocator getParentLocator() {
        return this.parentLocator;
    }

    public ObjectLocator[] getPath() {
        ObjectLocator[] path = new ObjectLocator[this.getAncestorCount(this) + 1];
        this.fillPath(this, path, path.length - 1);
        return path;
    }

    private void fillPath(ObjectLocator locator, ObjectLocator[] path, int index) {
        path[index] = locator;
        ObjectLocator parent = locator.getParentLocator();
        if (parent != null) {
            this.fillPath(parent, path, index - 1);
        }
    }

    private int getAncestorCount(ObjectLocator locator) {
        ObjectLocator parent = locator.getParentLocator();
        if (parent == null) {
            return 0;
        }
        return 1 + this.getAncestorCount(parent);
    }

    public Object getObject() {
        return this.object;
    }

    public int getColumnNumber() {
        return 0;
    }

    public int getLineNumber() {
        return 0;
    }

    public int getOffset() {
        return 0;
    }

    public URL getURL() {
        return null;
    }

    public Node getNode() {
        return null;
    }

    public String toString() {
        return this.getMessage();
    }

    public String getMessageCode() {
        return this.getClass().getName();
    }

    public Object[] getMessageParameters() {
        return new Object[]{this.getObject()};
    }

    public String getMessage(ResourceBundle bundle) {
        try {
            String messageTemplate = bundle.getString(this.getMessageCode());
            return MessageFormat.format(messageTemplate, this.getMessageParameters());
        }
        catch (MissingResourceException mrex) {
            return MessageFormat.format("Object: {0}.", this.getMessageParameters());
        }
    }

    public String getMessage() {
        return this.getMessage(ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".messages"));
    }

    public int hashCode() {
        int hashCode = this.getObject().hashCode();
        return hashCode;
    }
}

