/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbcommons.locator;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jvnet.jaxbcommons.locator.AbstractObjectLocator;
import org.jvnet.jaxbcommons.locator.FieldObjectLocator;
import org.jvnet.jaxbcommons.locator.ObjectLocator;

public final class DefaultFieldObjectLocator
extends AbstractObjectLocator
implements FieldObjectLocator {
    protected final String fieldName;

    public DefaultFieldObjectLocator(ObjectLocator parentLocator, Object object, String fieldName) {
        super(parentLocator, object);
        this.fieldName = fieldName;
    }

    public DefaultFieldObjectLocator(ObjectLocator locator, String fieldName) {
        super(locator.getParentLocator(), locator.getObject());
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object[] getMessageParameters() {
        return new Object[]{this.getObject(), this.getFieldName()};
    }

    public String getMessage(ResourceBundle bundle) {
        try {
            String messageTemplate = bundle.getString(this.getMessageCode());
            return MessageFormat.format(messageTemplate, this.getMessageParameters());
        }
        catch (MissingResourceException mrex) {
            return MessageFormat.format("Object: {0}\nField: {1}.", this.getMessageParameters());
        }
    }

    public int hashCode() {
        String fieldName = this.getFieldName();
        int hashCode = super.hashCode();
        hashCode = hashCode * 49 + (fieldName == null ? 0 : fieldName.hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof FieldObjectLocator) {
            FieldObjectLocator locator = (FieldObjectLocator)obj;
            result = this.getObject() == locator.getObject() && this.getFieldName().equals(locator.getFieldName());
        }
        return result;
    }
}

