/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbcommons.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EnumUtils {
    private EnumUtils() {
    }

    public static String[] createCodes(Map enumCodeMap, Object[] ens) {
        String[] codes = new String[ens.length];
        for (int index = 0; index < codes.length; ++index) {
            String code;
            Object value = ens[index];
            codes[index] = code = (String)enumCodeMap.get(value);
        }
        return codes;
    }

    public static Map createEnumCodeMap(Map codeEnumMap) {
        HashMap enumCodeMap = new HashMap(codeEnumMap.size());
        Iterator iterator = codeEnumMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object code = entry.getKey();
            Object value = entry.getValue();
            enumCodeMap.put(value, code);
        }
        return enumCodeMap;
    }

    public static String[] orderCodes(List enumsOrder, String[] codes) {
        List<String> oldCodes = Arrays.asList(codes);
        ArrayList<String> newCodes = new ArrayList<String>(codes.length);
        Iterator iterator = enumsOrder.iterator();
        while (iterator.hasNext()) {
            String code = (String)iterator.next();
            if ("*".equals(code)) {
                newCodes.addAll(oldCodes);
                oldCodes.clear();
                continue;
            }
            if (!oldCodes.remove(code)) continue;
            newCodes.add(code);
        }
        return newCodes.toArray(new String[newCodes.size()]);
    }

    public static Map orderEnumMap(Map oldEnumMap, String[] codes) {
        HashMap newEnumMap = new HashMap(oldEnumMap.size());
        for (int index = 0; index < codes.length; ++index) {
            String code = codes[index];
            Object value = oldEnumMap.get(code);
            if (code == null || value == null) continue;
            newEnumMap.put(code, value);
        }
        return newEnumMap;
    }

    public static Map orderEnumCodeMap(Map oldEnumMap, String[] codes) {
        HashMap newEnumCodeMap = new HashMap(oldEnumMap.size());
        for (int index = 0; index < codes.length; ++index) {
            String code = codes[index];
            Object value = oldEnumMap.get(code);
            if (code == null || value == null) continue;
            newEnumCodeMap.put(value, code);
        }
        return newEnumCodeMap;
    }
}

