/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbcommons.addon.tests;

import com.sun.tools.xjc.Driver;
import java.io.File;
import java.io.FileFilter;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractAddOnTest
extends TestCase {
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public List getAddonOptions() {
        ArrayList addonOptions = new ArrayList();
        return addonOptions;
    }

    public String[] getArguments() {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(this.getOptions());
        args.addAll(this.getBindingOptions());
        if (this.isDebug()) {
            args.add("-debug");
        }
        if (this.isNv()) {
            args.add("-nv");
        }
        if (this.isExtension()) {
            args.add("-extension");
        }
        args.addAll(this.getAddonOptions());
        args.addAll(this.getSchemaOptions());
        return args.toArray(new String[0]);
    }

    public List getOptions() {
        return Arrays.asList("-d", this.getGeneratedSourcesDir().getAbsolutePath());
    }

    protected boolean isDebug() {
        return true;
    }

    protected boolean isNv() {
        return true;
    }

    protected boolean isExtension() {
        return true;
    }

    public List getSchemaOptions() {
        File[] schemaFiles = this.getSchemaFiles();
        ArrayList<String> schemaOptions = new ArrayList<String>(schemaFiles.length);
        for (int index = 0; index < schemaFiles.length; ++index) {
            File schemaFile = schemaFiles[index];
            schemaOptions.add(schemaFile.getAbsolutePath());
        }
        return schemaOptions;
    }

    public File getSchemaDirectory() {
        return new File(this.getBaseDir(), "src/main/resources");
    }

    public File[] getSchemaFiles() {
        Collection schemaFiles = FileUtils.listFiles((File)this.getSchemaDirectory(), (String[])new String[]{"xsd"}, (boolean)true);
        return schemaFiles.toArray(new File[schemaFiles.size()]);
    }

    public File getBindingDirectory() {
        return new File(this.getBaseDir(), "src/main/resources");
    }

    public File[] getBindingFiles() {
        SuffixFileFilter fileFilter = new SuffixFileFilter(".xjb");
        return this.getBindingDirectory().listFiles((FileFilter)fileFilter);
    }

    public List getBindingOptions() {
        File[] bindingFiles = this.getBindingFiles();
        ArrayList<String> bindingOptions = new ArrayList<String>();
        if (null != bindingFiles && bindingFiles.length > 0) {
            bindingOptions.add("-b");
            for (int index = 0; index < bindingFiles.length; ++index) {
                File bindingFile = bindingFiles[index];
                bindingOptions.add(bindingFile.getAbsolutePath());
            }
        }
        return bindingOptions;
    }

    public File getGeneratedSourcesDir() {
        File generatedSourcesDir = new File(this.getBaseDir(), "target/generated-sources/xjc");
        if (!generatedSourcesDir.exists()) {
            generatedSourcesDir.mkdirs();
        }
        return generatedSourcesDir;
    }

    public void testRun() throws Exception {
        try {
            Driver.run((String[])this.getArguments(), (PrintStream)System.out, (PrintStream)System.err);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public File getBaseDir() {
        try {
            URI base = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
            return new File(base).getParentFile().getParentFile().getAbsoluteFile();
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

