/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbvalidation.tests.one.validation;

import com.sun.msv.datatype.xsd.datetime.BigDateTimeValueType;
import com.sun.org.apache.xerces.internal.impl.xpath.regex.RegularExpression;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.jvnet.jaxbcommons.locator.DefaultFieldObjectLocator;
import org.jvnet.jaxbcommons.locator.ObjectLocator;
import org.jvnet.jaxbvalidation.event.ObjectValidationEvent;
import org.jvnet.jaxbvalidation.problem.Problem;
import org.jvnet.jaxbvalidation.problem.datatype.EnumerationProblem;
import org.jvnet.jaxbvalidation.problem.datatype.RegularExpressionProblem;
import org.jvnet.jaxbvalidation.problem.datatype.RegularExpressionsProblem;
import org.jvnet.jaxbvalidation.problem.structure.NonExpectedClassProblem;
import org.jvnet.jaxbvalidation.tests.one.FacetType;
import org.jvnet.jaxbvalidation.tests.one.TypeSafeStringEnumeration;
import org.jvnet.jaxbvalidation.validator.ObjectValidator;
import org.jvnet.jaxbvalidation.validator.ValueValidator;

public class FacetTypeObjectValidator
implements ObjectValidator {
    public static final FacetTypeObjectValidator INSTANCE = new FacetTypeObjectValidator();

    public void check(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
        if (draftValue != null) {
            Object fieldValidator;
            DefaultFieldObjectLocator fieldLocator;
            FacetType value = (FacetType)draftValue;
            if (value.isSetSinglePattern()) {
                fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "SinglePattern");
                if (value.isSetSinglePattern()) {
                    fieldValidator = SinglePatternFieldValidator.INSTANCE;
                    fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getSinglePattern());
                }
            }
            if (value.isSetMultiplePatterns()) {
                fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "MultiplePatterns");
                if (value.isSetMultiplePatterns()) {
                    fieldValidator = MultiplePatternsFieldValidator.INSTANCE;
                    fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getMultiplePatterns());
                }
            }
            if (value.isSetStringEnumeration()) {
                fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "StringEnumeration");
                if (value.isSetStringEnumeration()) {
                    fieldValidator = StringEnumerationFieldValidator.INSTANCE;
                    fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getStringEnumeration());
                }
            }
            if (value.isSetTypeSafeStringEnumeration()) {
                fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "TypeSafeStringEnumeration");
                if (value.isSetTypeSafeStringEnumeration()) {
                    fieldValidator = TypeSafeStringEnumerationFieldValidator.INSTANCE;
                    fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getTypeSafeStringEnumeration());
                }
            }
            if (value.isSetIntEnumeration()) {
                fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "IntEnumeration");
                if (value.isSetIntEnumeration()) {
                    fieldValidator = IntEnumerationFieldValidator.INSTANCE;
                    fieldValidator.check((ObjectLocator)fieldLocator, handler, new Integer(value.getIntEnumeration()));
                }
            }
            if (value.isSetDateEnumeration()) {
                fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "DateEnumeration");
                if (value.isSetDateEnumeration()) {
                    fieldValidator = DateEnumerationFieldValidator.INSTANCE;
                    fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getDateEnumeration());
                }
            }
            if (value.isSetTimeEnumeration()) {
                fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "TimeEnumeration");
                if (value.isSetTimeEnumeration()) {
                    fieldValidator = TimeEnumerationFieldValidator.INSTANCE;
                    fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getTimeEnumeration());
                }
            }
        }
    }

    public static class TypeSafeStringEnumerationFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final TypeSafeStringEnumerationFieldValidator INSTANCE = new TypeSafeStringEnumerationFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            TypeSafeStringEnumeration value = (TypeSafeStringEnumeration)draftValue;
            if (value instanceof TypeSafeStringEnumeration) {
                TypeSafeStringEnumeration realValue = value;
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class TimeEnumerationFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final TimeEnumerationFieldValidator INSTANCE = new TimeEnumerationFieldValidator();
        protected Object[] values = new Object[]{new BigDateTimeValueType(null, null, null, new Integer(0), new Integer(0), new BigDecimal("1"), null).toCalendar(), new BigDateTimeValueType(null, null, null, new Integer(23), new Integer(59), new BigDecimal("59"), null).toCalendar(), new BigDateTimeValueType(null, null, null, new Integer(0), new Integer(0), new BigDecimal("0"), null).toCalendar()};
        protected Set valueSet = Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(this.values)));

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            Calendar value = (Calendar)draftValue;
            if (value instanceof Calendar) {
                Calendar realValue = value;
                EnumerationProblem problem = null;
                if (!this.valueSet.contains(realValue)) {
                    problem = new EnumerationProblem((Object)realValue, this.valueSet);
                }
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class StringEnumerationFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final StringEnumerationFieldValidator INSTANCE = new StringEnumerationFieldValidator();
        protected Object[] values = new Object[]{"d", "a", "c", "b"};
        protected Set valueSet = Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(this.values)));

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            String value = (String)draftValue;
            if (value instanceof String) {
                String realValue = value;
                EnumerationProblem problem = null;
                if (!this.valueSet.contains(realValue)) {
                    problem = new EnumerationProblem((Object)realValue, this.valueSet);
                }
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class SinglePatternFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final SinglePatternFieldValidator INSTANCE = new SinglePatternFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            String value = (String)draftValue;
            if (value instanceof String) {
                String realValue = value;
                RegularExpressionProblem problem = null;
                if (!new RegularExpression("[A-Z]{2}", "X").matches(realValue.toString())) {
                    problem = new RegularExpressionProblem((Object)realValue, "[A-Z]{2}");
                }
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class MultiplePatternsFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final MultiplePatternsFieldValidator INSTANCE = new MultiplePatternsFieldValidator();
        protected RegularExpression[] regExps = new RegularExpression[]{new RegularExpression("[A-Z]{2}", "X"), new RegularExpression("[a-z]{2}", "X"), new RegularExpression("[0-9]{2}", "X")};
        protected String[] patterns = new String[]{"[A-Z]{2}", "[a-z]{2}", "[0-9]{2}"};

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            String value = (String)draftValue;
            if (value instanceof String) {
                String realValue = value;
                RegularExpressionsProblem problem = null;
                int matches = 0;
                for (int index = 0; index < this.regExps.length; ++index) {
                    if (!this.regExps[index].matches(realValue.toString())) continue;
                    ++matches;
                }
                if (matches == 0) {
                    problem = new RegularExpressionsProblem((Object)realValue, this.patterns);
                }
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class IntEnumerationFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final IntEnumerationFieldValidator INSTANCE = new IntEnumerationFieldValidator();
        protected Object[] values = new Object[]{new Integer(2), new Integer(4), new Integer(1), new Integer(3)};
        protected Set valueSet = Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(this.values)));

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            Integer value = (Integer)draftValue;
            if (value instanceof Integer) {
                Integer realValue = value;
                EnumerationProblem problem = null;
                if (!this.valueSet.contains(realValue)) {
                    problem = new EnumerationProblem((Object)realValue, this.valueSet);
                }
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class DateEnumerationFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final DateEnumerationFieldValidator INSTANCE = new DateEnumerationFieldValidator();
        protected Object[] values = new Object[]{new BigDateTimeValueType(new BigInteger("2002"), new Integer(1), new Integer(0), null, null, null, null).toCalendar(), new BigDateTimeValueType(new BigInteger("2002"), new Integer(0), new Integer(0), null, null, null, null).toCalendar(), new BigDateTimeValueType(new BigInteger("2001"), new Integer(11), new Integer(30), null, null, null, null).toCalendar()};
        protected Set valueSet = Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(this.values)));

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            Calendar value = (Calendar)draftValue;
            if (value instanceof Calendar) {
                Calendar realValue = value;
                EnumerationProblem problem = null;
                if (!this.valueSet.contains(realValue)) {
                    problem = new EnumerationProblem((Object)realValue, this.valueSet);
                }
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }
}

