/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbvalidation.tests.one.validation;

import com.sun.msv.datatype.xsd.XmlNames;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.List;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import org.jvnet.jaxbcommons.locator.DefaultFieldObjectLocator;
import org.jvnet.jaxbcommons.locator.DefaultListEntryObjectLocator;
import org.jvnet.jaxbcommons.locator.ObjectLocator;
import org.jvnet.jaxbvalidation.event.ObjectValidationEvent;
import org.jvnet.jaxbvalidation.problem.Problem;
import org.jvnet.jaxbvalidation.problem.datatype.AnyURIProblem;
import org.jvnet.jaxbvalidation.problem.datatype.GreaterProblem;
import org.jvnet.jaxbvalidation.problem.datatype.LanguageProblem;
import org.jvnet.jaxbvalidation.problem.datatype.NameProblem;
import org.jvnet.jaxbvalidation.problem.datatype.NcnameProblem;
import org.jvnet.jaxbvalidation.problem.datatype.NegativeProblem;
import org.jvnet.jaxbvalidation.problem.datatype.NmtokenProblem;
import org.jvnet.jaxbvalidation.problem.datatype.NonNegativeProblem;
import org.jvnet.jaxbvalidation.problem.datatype.NonPositiveProblem;
import org.jvnet.jaxbvalidation.problem.datatype.PositiveProblem;
import org.jvnet.jaxbvalidation.problem.structure.EmptyFieldProblem;
import org.jvnet.jaxbvalidation.problem.structure.NonExpectedClassProblem;
import org.jvnet.jaxbvalidation.problem.structure.TooFewElementsProblem;
import org.jvnet.jaxbvalidation.tests.one.SimpleTypesType;
import org.jvnet.jaxbvalidation.util.ValidationUtils;
import org.jvnet.jaxbvalidation.validator.EntryValidator;
import org.jvnet.jaxbvalidation.validator.ObjectValidator;
import org.jvnet.jaxbvalidation.validator.ValueValidator;

public class SimpleTypesTypeObjectValidator
implements ObjectValidator {
    public static final SimpleTypesTypeObjectValidator INSTANCE = new SimpleTypesTypeObjectValidator();

    public void check(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
        if (draftValue != null) {
            Object fieldValidator;
            SimpleTypesType value = (SimpleTypesType)draftValue;
            DefaultFieldObjectLocator fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "Base64Binary");
            if (!value.isSetBase64Binary()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = Base64BinaryFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getBase64Binary());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "HexBinary");
            if (!value.isSetHexBinary()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = HexBinaryFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getHexBinary());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "Duration");
            if (!value.isSetDuration()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = DurationFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getDuration());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "DateTime");
            if (!value.isSetDateTime()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = DateTimeFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getDateTime());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "Date");
            if (!value.isSetDate()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = DateFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getDate());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "Time");
            if (!value.isSetTime()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = TimeFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getTime());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "GYearMonth");
            if (!value.isSetGYearMonth()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = GYearMonthFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getGYearMonth());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "GYear");
            if (!value.isSetGYear()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = GYearFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getGYear());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "GMonthDay");
            if (!value.isSetGMonthDay()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = GMonthDayFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getGMonthDay());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "GDay");
            if (!value.isSetGDay()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = GDayFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getGDay());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "GMonth");
            if (!value.isSetGMonth()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = GMonthFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getGMonth());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "Float");
            if (!value.isSetFloat()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = FloatFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, new Float(value.getFloat()));
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "Double");
            if (!value.isSetDouble()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = DoubleFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, new Double(value.getDouble()));
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "Decimal");
            if (!value.isSetDecimal()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = DecimalFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getDecimal());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "Integer");
            if (!value.isSetInteger()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = IntegerFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getInteger());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "Long");
            if (!value.isSetLong()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = LongFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, new Long(value.getLong()));
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "Int");
            if (!value.isSetInt()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = IntFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, new Integer(value.getInt()));
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "Short");
            if (!value.isSetShort()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = ShortFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, new Short(value.getShort()));
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "Byte");
            if (!value.isSetByte()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = ByteFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, new Byte(value.getByte()));
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "UnsignedLong");
            if (!value.isSetUnsignedLong()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = UnsignedLongFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getUnsignedLong());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "UnsignedInt");
            if (!value.isSetUnsignedInt()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = UnsignedIntFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, new Long(value.getUnsignedInt()));
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "UnsignedShort");
            if (!value.isSetUnsignedShort()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = UnsignedShortFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, new Integer(value.getUnsignedShort()));
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "UnsignedByte");
            if (!value.isSetUnsignedByte()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = UnsignedByteFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, new Short(value.getUnsignedByte()));
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "NonNegativeInteger");
            if (!value.isSetNonNegativeInteger()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = NonNegativeIntegerFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getNonNegativeInteger());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "NonPositiveInteger");
            if (!value.isSetNonPositiveInteger()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = NonPositiveIntegerFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getNonPositiveInteger());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "PositiveInteger");
            if (!value.isSetPositiveInteger()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = PositiveIntegerFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getPositiveInteger());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "NegativeInteger");
            if (!value.isSetNegativeInteger()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = NegativeIntegerFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getNegativeInteger());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "Boolean");
            if (!value.isSetBoolean()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = BooleanFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, new Boolean(value.isBoolean()));
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "AnyURI");
            if (!value.isSetAnyURI()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = AnyURIFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getAnyURI());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "QName");
            if (!value.isSetQName()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = QNameFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getQName());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "String");
            if (!value.isSetString()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = StringFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getString());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "NormalizedString");
            if (!value.isSetNormalizedString()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = NormalizedStringFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getNormalizedString());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "Token");
            if (!value.isSetToken()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = TokenFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getToken());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "Language");
            if (!value.isSetLanguage()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = LanguageFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getLanguage());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "Name");
            if (!value.isSetName()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = NameFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getName());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "NCName");
            if (!value.isSetNCName()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = NCNameFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getNCName());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "ID");
            if (!value.isSetID()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = IDFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getID());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "IDREF");
            if (!value.isSetIDREF()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = IDREFFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getIDREF());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "IDREFS");
            if (!value.isSetIDREFS()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                if (value.getIDREFS().size() < 1) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new TooFewElementsProblem(value.getIDREFS().size(), 1)));
                }
                fieldValidator = IDREFSFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getIDREFS());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "ENTITY");
            if (!value.isSetENTITY()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = ENTITYFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getENTITY());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "ENTITIES");
            if (!value.isSetENTITIES()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                if (value.getENTITIES().size() < 1) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new TooFewElementsProblem(value.getENTITIES().size(), 1)));
                }
                fieldValidator = ENTITIESFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getENTITIES());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "NMTOKEN");
            if (!value.isSetNMTOKEN()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                fieldValidator = NMTOKENFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getNMTOKEN());
            }
            fieldLocator = new DefaultFieldObjectLocator(locator, (Object)value, "NMTOKENS");
            if (!value.isSetNMTOKENS()) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new EmptyFieldProblem()));
            } else {
                if (value.getNMTOKENS().size() < 1) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent((ObjectLocator)fieldLocator, (Problem)new TooFewElementsProblem(value.getNMTOKENS().size(), 1)));
                }
                fieldValidator = NMTOKENSFieldValidator.INSTANCE;
                fieldValidator.check((ObjectLocator)fieldLocator, handler, value.getNMTOKENS());
            }
        }
    }

    public static class UnsignedShortFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final UnsignedShortFieldValidator INSTANCE = new UnsignedShortFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            Integer value = (Integer)draftValue;
            if (value instanceof Integer) {
                Integer realValue = value;
                NegativeProblem problem = null;
                if (realValue < 0) {
                    problem = new NegativeProblem((Object)realValue);
                } else if (realValue > 65535) {
                    problem = new GreaterProblem((Object)realValue, (Object)new Integer(65535));
                }
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class UnsignedLongFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final UnsignedLongFieldValidator INSTANCE = new UnsignedLongFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            BigInteger value = (BigInteger)draftValue;
            if (value instanceof BigInteger) {
                BigInteger realValue = value;
                NegativeProblem problem = null;
                if (realValue.signum() < 0) {
                    problem = new NegativeProblem((Object)realValue);
                } else if (realValue.compareTo(new BigInteger("18446744073709551615")) > 0) {
                    problem = new GreaterProblem((Object)realValue, (Object)new BigInteger("18446744073709551615"));
                }
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class UnsignedIntFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final UnsignedIntFieldValidator INSTANCE = new UnsignedIntFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            Long value = (Long)draftValue;
            if (value instanceof Long) {
                Long realValue = value;
                NegativeProblem problem = null;
                if (realValue < 0L) {
                    problem = new NegativeProblem((Object)realValue);
                } else if (realValue > 0xFFFFFFFFL) {
                    problem = new GreaterProblem((Object)realValue, (Object)new Long(0xFFFFFFFFL));
                }
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class UnsignedByteFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final UnsignedByteFieldValidator INSTANCE = new UnsignedByteFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            Short value = (Short)draftValue;
            if (value instanceof Short) {
                Short realValue = value;
                NegativeProblem problem = null;
                if (realValue < 0) {
                    problem = new NegativeProblem((Object)realValue);
                } else if (realValue > 255) {
                    problem = new GreaterProblem((Object)realValue, (Object)new Integer(255));
                }
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class TokenFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final TokenFieldValidator INSTANCE = new TokenFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            String value = (String)draftValue;
            if (value instanceof String) {
                String realValue = value;
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class TimeFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final TimeFieldValidator INSTANCE = new TimeFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            Calendar value = (Calendar)draftValue;
            if (value instanceof Calendar) {
                Calendar realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class StringFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final StringFieldValidator INSTANCE = new StringFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            String value = (String)draftValue;
            if (value instanceof String) {
                String realValue = value;
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class ShortFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final ShortFieldValidator INSTANCE = new ShortFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            Short value = (Short)draftValue;
            if (value instanceof Short) {
                Short realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class QNameFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final QNameFieldValidator INSTANCE = new QNameFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            QName value = (QName)draftValue;
            if (value instanceof QName) {
                QName realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class PositiveIntegerFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final PositiveIntegerFieldValidator INSTANCE = new PositiveIntegerFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            BigInteger value = (BigInteger)draftValue;
            if (value instanceof BigInteger) {
                BigInteger realValue = value;
                NonPositiveProblem problem = null;
                if (realValue.signum() != 1) {
                    problem = new NonPositiveProblem((Object)realValue);
                }
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class NormalizedStringFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final NormalizedStringFieldValidator INSTANCE = new NormalizedStringFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            String value = (String)draftValue;
            if (value instanceof String) {
                String realValue = value;
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class NonPositiveIntegerFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final NonPositiveIntegerFieldValidator INSTANCE = new NonPositiveIntegerFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            BigInteger value = (BigInteger)draftValue;
            if (value instanceof BigInteger) {
                BigInteger realValue = value;
                PositiveProblem problem = null;
                if (realValue.signum() > 0) {
                    problem = new PositiveProblem((Object)realValue);
                }
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class NonNegativeIntegerFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final NonNegativeIntegerFieldValidator INSTANCE = new NonNegativeIntegerFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            BigInteger value = (BigInteger)draftValue;
            if (value instanceof BigInteger) {
                BigInteger realValue = value;
                NegativeProblem problem = null;
                if (realValue.signum() < 0) {
                    problem = new NegativeProblem((Object)realValue);
                }
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class NegativeIntegerFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final NegativeIntegerFieldValidator INSTANCE = new NegativeIntegerFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            BigInteger value = (BigInteger)draftValue;
            if (value instanceof BigInteger) {
                BigInteger realValue = value;
                NonNegativeProblem problem = null;
                if (realValue.signum() != -1) {
                    problem = new NonNegativeProblem((Object)realValue);
                }
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class NameFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final NameFieldValidator INSTANCE = new NameFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            String value = (String)draftValue;
            if (value instanceof String) {
                String realValue = value;
                NameProblem problem = null;
                if (!XmlNames.isName((String)realValue)) {
                    problem = new NameProblem((Object)realValue);
                }
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class NMTOKENSFieldValidator
    implements ObjectValidator,
    EntryValidator,
    ValueValidator {
        public static final NMTOKENSFieldValidator INSTANCE = new NMTOKENSFieldValidator();

        public void check(ObjectLocator parentLocator, ValidationEventHandler handler, Object value) {
            List values = (List)value;
            DefaultFieldObjectLocator locator = new DefaultFieldObjectLocator(parentLocator, "NMTOKENS");
            if (values != null) {
                for (int index = 0; index < values.size(); ++index) {
                    Object item = values.get(index);
                    this.checkEntry((ObjectLocator)locator, handler, index, item);
                }
            }
        }

        public void checkEntry(ObjectLocator locator, ValidationEventHandler handler, int index, Object value) {
            DefaultListEntryObjectLocator entryLocator = new DefaultListEntryObjectLocator(locator, index);
            this.checkValue((ObjectLocator)entryLocator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            String value = (String)draftValue;
            if (value instanceof String) {
                String realValue = value;
                NmtokenProblem problem = null;
                if (!XmlNames.isNmtoken((String)realValue)) {
                    problem = new NmtokenProblem((Object)realValue);
                }
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class NMTOKENFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final NMTOKENFieldValidator INSTANCE = new NMTOKENFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            String value = (String)draftValue;
            if (value instanceof String) {
                String realValue = value;
                NmtokenProblem problem = null;
                if (!XmlNames.isNmtoken((String)realValue)) {
                    problem = new NmtokenProblem((Object)realValue);
                }
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class NCNameFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final NCNameFieldValidator INSTANCE = new NCNameFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            String value = (String)draftValue;
            if (value instanceof String) {
                String realValue = value;
                NcnameProblem problem = null;
                if (!XmlNames.isNCName((String)realValue)) {
                    problem = new NcnameProblem((Object)realValue);
                }
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class LongFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final LongFieldValidator INSTANCE = new LongFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            Long value = (Long)draftValue;
            if (value instanceof Long) {
                Long realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class LanguageFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final LanguageFieldValidator INSTANCE = new LanguageFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            String value = (String)draftValue;
            if (value instanceof String) {
                String realValue = value;
                LanguageProblem problem = null;
                if (!ValidationUtils.isLanguage((String)realValue)) {
                    problem = new LanguageProblem((Object)realValue);
                }
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class IntegerFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final IntegerFieldValidator INSTANCE = new IntegerFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            BigInteger value = (BigInteger)draftValue;
            if (value instanceof BigInteger) {
                BigInteger realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class IntFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final IntFieldValidator INSTANCE = new IntFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            Integer value = (Integer)draftValue;
            if (value instanceof Integer) {
                Integer realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class IDREFSFieldValidator
    implements ObjectValidator,
    EntryValidator,
    ValueValidator {
        public static final IDREFSFieldValidator INSTANCE = new IDREFSFieldValidator();

        public void check(ObjectLocator parentLocator, ValidationEventHandler handler, Object value) {
            List values = (List)value;
            DefaultFieldObjectLocator locator = new DefaultFieldObjectLocator(parentLocator, "IDREFS");
            if (values != null) {
                for (int index = 0; index < values.size(); ++index) {
                    Object item = values.get(index);
                    this.checkEntry((ObjectLocator)locator, handler, index, item);
                }
            }
        }

        public void checkEntry(ObjectLocator locator, ValidationEventHandler handler, int index, Object value) {
            DefaultListEntryObjectLocator entryLocator = new DefaultListEntryObjectLocator(locator, index);
            this.checkValue((ObjectLocator)entryLocator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            Object value = draftValue;
            if (value instanceof Object) {
                Object realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class IDREFFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final IDREFFieldValidator INSTANCE = new IDREFFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            Object value = draftValue;
            if (value instanceof Object) {
                Object realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class IDFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final IDFieldValidator INSTANCE = new IDFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            String value = (String)draftValue;
            if (value instanceof String) {
                String realValue = value;
                NcnameProblem problem = null;
                if (!XmlNames.isNCName((String)realValue)) {
                    problem = new NcnameProblem((Object)realValue);
                }
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class HexBinaryFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final HexBinaryFieldValidator INSTANCE = new HexBinaryFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            byte[] value = (byte[])draftValue;
            if (value instanceof byte[]) {
                byte[] realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class GYearMonthFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final GYearMonthFieldValidator INSTANCE = new GYearMonthFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            String value = (String)draftValue;
            if (value instanceof String) {
                String realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class GYearFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final GYearFieldValidator INSTANCE = new GYearFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            String value = (String)draftValue;
            if (value instanceof String) {
                String realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class GMonthFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final GMonthFieldValidator INSTANCE = new GMonthFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            String value = (String)draftValue;
            if (value instanceof String) {
                String realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class GMonthDayFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final GMonthDayFieldValidator INSTANCE = new GMonthDayFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            String value = (String)draftValue;
            if (value instanceof String) {
                String realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class GDayFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final GDayFieldValidator INSTANCE = new GDayFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            String value = (String)draftValue;
            if (value instanceof String) {
                String realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class FloatFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final FloatFieldValidator INSTANCE = new FloatFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            Float value = (Float)draftValue;
            if (value instanceof Float) {
                Float realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class ENTITYFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final ENTITYFieldValidator INSTANCE = new ENTITYFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            String value = (String)draftValue;
            if (value instanceof String) {
                String realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class ENTITIESFieldValidator
    implements ObjectValidator,
    EntryValidator,
    ValueValidator {
        public static final ENTITIESFieldValidator INSTANCE = new ENTITIESFieldValidator();

        public void check(ObjectLocator parentLocator, ValidationEventHandler handler, Object value) {
            List values = (List)value;
            DefaultFieldObjectLocator locator = new DefaultFieldObjectLocator(parentLocator, "ENTITIES");
            if (values != null) {
                for (int index = 0; index < values.size(); ++index) {
                    Object item = values.get(index);
                    this.checkEntry((ObjectLocator)locator, handler, index, item);
                }
            }
        }

        public void checkEntry(ObjectLocator locator, ValidationEventHandler handler, int index, Object value) {
            DefaultListEntryObjectLocator entryLocator = new DefaultListEntryObjectLocator(locator, index);
            this.checkValue((ObjectLocator)entryLocator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            String value = (String)draftValue;
            if (value instanceof String) {
                String realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class DurationFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final DurationFieldValidator INSTANCE = new DurationFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            String value = (String)draftValue;
            if (value instanceof String) {
                String realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class DoubleFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final DoubleFieldValidator INSTANCE = new DoubleFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            Double value = (Double)draftValue;
            if (value instanceof Double) {
                Double realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class DecimalFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final DecimalFieldValidator INSTANCE = new DecimalFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            BigDecimal value = (BigDecimal)draftValue;
            if (value instanceof BigDecimal) {
                BigDecimal realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class DateTimeFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final DateTimeFieldValidator INSTANCE = new DateTimeFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            Calendar value = (Calendar)draftValue;
            if (value instanceof Calendar) {
                Calendar realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class DateFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final DateFieldValidator INSTANCE = new DateFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            Calendar value = (Calendar)draftValue;
            if (value instanceof Calendar) {
                Calendar realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class ByteFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final ByteFieldValidator INSTANCE = new ByteFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            Byte value = (Byte)draftValue;
            if (value instanceof Byte) {
                Byte realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class BooleanFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final BooleanFieldValidator INSTANCE = new BooleanFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            Boolean value = (Boolean)draftValue;
            if (value instanceof Boolean) {
                Boolean realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class Base64BinaryFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final Base64BinaryFieldValidator INSTANCE = new Base64BinaryFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            byte[] value = (byte[])draftValue;
            if (value instanceof byte[]) {
                byte[] realValue = value;
                Problem problem = null;
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }

    public static class AnyURIFieldValidator
    implements ObjectValidator,
    ValueValidator {
        public static final AnyURIFieldValidator INSTANCE = new AnyURIFieldValidator();

        public void check(ObjectLocator locator, ValidationEventHandler handler, Object value) {
            this.checkValue(locator, handler, value);
        }

        public void checkValue(ObjectLocator locator, ValidationEventHandler handler, Object draftValue) {
            String value = (String)draftValue;
            if (value instanceof String) {
                String realValue = value;
                AnyURIProblem problem = null;
                if (!ValidationUtils.isAnyURI((String)realValue)) {
                    problem = new AnyURIProblem((Object)realValue);
                }
                if (null != problem) {
                    handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)problem));
                }
            } else if (null != value) {
                handler.handleEvent((ValidationEvent)new ObjectValidationEvent(locator, (Problem)new NonExpectedClassProblem(value.getClass())));
            }
        }
    }
}

