/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbvalidation.event;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventLocator;
import org.jvnet.jaxbcommons.locator.ObjectLocator;
import org.jvnet.jaxbvalidation.problem.Problem;

public class ObjectValidationEvent
implements ValidationEvent {
    protected final ObjectLocator locator;
    protected final Problem problem;

    public ObjectValidationEvent(ObjectLocator locator, Problem problem) {
        this.locator = locator;
        this.problem = problem;
    }

    public int getSeverity() {
        return 0;
    }

    public ValidationEventLocator getLocator() {
        return this.locator;
    }

    public ObjectLocator getValidationEventLocator() {
        return this.locator;
    }

    public Throwable getLinkedException() {
        return this.problem;
    }

    public Problem getProblem() {
        return this.problem;
    }

    public String getMessageCode() {
        return this.getClass().getName();
    }

    public String getMessage(ResourceBundle bundle) {
        Object[] messageParameters = new Object[]{this.getValidationEventLocator().getMessage(bundle), this.getProblem().getMessage(bundle)};
        try {
            return MessageFormat.format(bundle.getString(this.getMessageCode()), messageParameters);
        }
        catch (MissingResourceException mrex) {
            return MessageFormat.format("Location:\n{0}\nProblem:\n{1}", messageParameters);
        }
    }

    public String getMessage() {
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".messages");
        Object[] messageParameters = new Object[]{this.getValidationEventLocator().getMessage(), this.getProblem().getMessage()};
        try {
            return MessageFormat.format(bundle.getString(this.getMessageCode()), messageParameters);
        }
        catch (MissingResourceException mrex) {
            return MessageFormat.format("Location:\n{0}\nProblem:\n{1}", messageParameters);
        }
    }

    public int hashCode() {
        return this.getLinkedException().hashCode() + this.getLocator().hashCode() * 37;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof ValidationEvent) {
            ValidationEvent event = (ValidationEvent)obj;
            result = this.getSeverity() == event.getSeverity() && this.getLocator().equals(event.getLocator()) && this.getLinkedException().equals(event.getLinkedException());
        }
        return result;
    }

    public String toString() {
        return this.getMessage();
    }
}

