/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbvalidation.problem;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.ArrayUtils;
import org.jvnet.jaxbcommons.i18n.Reportable;

public abstract class Problem
extends Exception
implements Reportable {
    public String getMessageCode() {
        return this.getClass().getName();
    }

    public abstract Object[] getMessageParameters();

    public String getMessage(ResourceBundle bundle) {
        try {
            String messageTemplate = bundle.getString(this.getMessageCode());
            String message = MessageFormat.format(messageTemplate, this.getMessageParameters());
            return message;
        }
        catch (MissingResourceException mrex) {
            return "Message [" + this.getMessageCode() + "].";
        }
    }

    public String getMessage() {
        return this.getMessage(this.getDefaultResourceBundle());
    }

    public abstract ResourceBundle getDefaultResourceBundle();

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof Problem) {
            Problem problem = (Problem)obj;
            result = ArrayUtils.isEquals((Object)this.getMessageParameters(), (Object)problem.getMessageParameters());
        }
        return result;
    }

    public int hashCode() {
        int hashCode = 0;
        Object[] messageParameters = this.getMessageParameters();
        for (int index = 0; index < messageParameters.length; ++index) {
            hashCode = hashCode * 31 + messageParameters[index].hashCode();
        }
        return hashCode;
    }

    public String toString() {
        return this.getMessage();
    }
}

