/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxbvalidation.util;

import com.sun.msv.datatype.xsd.regex.RegExp;
import com.sun.msv.datatype.xsd.regex.RegExpFactory;
import java.text.ParseException;

public class ValidationUtils {
    private static final boolean[] isUric = ValidationUtils.createUricMap();
    private static final RegExp ANYURI_REGEXP;

    private ValidationUtils() {
    }

    private static void appendHex(StringBuffer buf, int hex) {
        if (hex < 10) {
            buf.append((char)(hex + 48));
        } else {
            buf.append((char)(hex - 10 + 65));
        }
    }

    private static void appendByte(StringBuffer buf, int ch) {
        buf.append('%');
        ValidationUtils.appendHex(buf, ch / 16);
        ValidationUtils.appendHex(buf, ch % 16);
    }

    private static void appendEscaped(StringBuffer buf, char ch) {
        if (ch < '\u007f') {
            ValidationUtils.appendByte(buf, ch);
            return;
        }
        if (ch < '\u07ff') {
            ValidationUtils.appendByte(buf, 192 + (ch >> 6));
            ValidationUtils.appendByte(buf, 128 + ch % 64);
            return;
        }
        if (ch < '\uffff') {
            ValidationUtils.appendByte(buf, 224 + (ch >> 12));
            ValidationUtils.appendByte(buf, 128 + (ch >> 6) % 64);
            ValidationUtils.appendByte(buf, 128 + ch % 64);
        }
    }

    private static void appendEscaped(StringBuffer buf, char ch1, char ch2) {
        int ucs = ((ch1 & 0x3FF) << 10) + (ch2 & 0x3FF);
        ValidationUtils.appendByte(buf, 240 + (ucs >> 18));
        ValidationUtils.appendByte(buf, 128 + (ucs >> 12) % 64);
        ValidationUtils.appendByte(buf, 128 + (ucs >> 6) % 64);
        ValidationUtils.appendByte(buf, 128 + ucs % 64);
    }

    private static boolean[] createUricMap() {
        int i;
        boolean[] r = new boolean[128];
        for (i = 97; i <= 122; ++i) {
            r[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            r[i] = true;
        }
        for (i = 48; i <= 57; ++i) {
            r[i] = true;
        }
        char[] mark = new char[]{'-', '_', '.', '!', '~', '*', '\'', '(', ')', '#', '%', '[', ']'};
        for (int i2 = 0; i2 < mark.length; ++i2) {
            r[mark[i2]] = true;
        }
        char[] reserved = new char[]{';', '/', '?', ':', '@', '&', '=', '+', '$', ','};
        for (int i3 = 0; i3 < reserved.length; ++i3) {
            r[reserved[i3]] = true;
        }
        return r;
    }

    public static String escape(String content) {
        StringBuffer escaped = new StringBuffer(content.length());
        for (int i = 0; i < content.length(); ++i) {
            char ch = content.charAt(i);
            if (ch < '\u0080' && isUric[ch]) {
                escaped.append(ch);
                continue;
            }
            if ('\ud800' <= ch && ch < '\udc00') {
                ValidationUtils.appendEscaped(escaped, ch, content.charAt(++i));
                continue;
            }
            ValidationUtils.appendEscaped(escaped, ch);
        }
        return new String(escaped);
    }

    public static boolean isAnyURI(String value) {
        return ANYURI_REGEXP.matches(ValidationUtils.escape(value));
    }

    public static boolean isLanguage(String value) {
        int len = value.length();
        int i = 0;
        int tokenSize = 0;
        while (i < len) {
            char ch;
            if ('a' <= (ch = value.charAt(i++)) && ch <= 'z' || 'A' <= ch && ch <= 'Z') {
                if (++tokenSize != 9) continue;
                return false;
            }
            if (ch == '-') {
                if (tokenSize == 0) {
                    return false;
                }
                tokenSize = 0;
                continue;
            }
            return false;
        }
        return tokenSize != 0;
    }

    static {
        try {
            String alpha = "[a-zA-Z]";
            String alphanum = "[0-9a-zA-Z]";
            String hex = "[0-9a-fA-F]";
            String escaped = "%[0-9a-fA-F]{2}";
            String mark = "[\\-_\\.!~\\*'\\(\\)]";
            String unreserved = "([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])";
            String reserved = "[;/\\?:@&=\\+$,\\[\\]]";
            String uric = "([;/\\?:@&=\\+$,\\[\\]]|([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2})";
            String fragment = "([;/\\?:@&=\\+$,\\[\\]]|([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2})*";
            String query = "([;/\\?:@&=\\+$,\\[\\]]|([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2})*";
            String pchar = "(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])";
            String param = "(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*";
            String segment = "((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*)";
            String pathSegments = "(((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*)(/((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*))*)";
            String port = "[0-9]*";
            String __upTo3digits = "[0-9]{1,3}";
            String IPv4address = "[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}";
            String hex4 = "[0-9a-fA-F]{1,4}";
            String hexseq = "[0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*";
            String hexpart = "(([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?)?)|(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?))";
            String IPv6address = "(((([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?)?)|(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?))(:[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})?)|(::[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}))";
            String IPv6reference = "\\[(((([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?)?)|(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?))(:[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})?)|(::[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}))\\]";
            String domainlabel = "[0-9a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?";
            String toplabel = "[a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?";
            String hostname = "([0-9a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?\\.)*[a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?(\\.)?";
            String host = "((([0-9a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?\\.)*[a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?(\\.)?)|([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})|(\\[(((([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?)?)|(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?))(:[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})?)|(::[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}))\\]))";
            String hostport = "((([0-9a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?\\.)*[a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?(\\.)?)|([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})|(\\[(((([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?)?)|(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?))(:[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})?)|(::[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}))\\]))(:[0-9]*)?";
            String userinfo = "(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[;:&=\\+$,])*";
            String server = "(((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[;:&=\\+$,])*@)?((([0-9a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?\\.)*[a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?(\\.)?)|([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})|(\\[(((([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?)?)|(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?))(:[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})?)|(::[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}))\\]))(:[0-9]*)?)?";
            String regName = "(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[$,;:@&=\\+])+";
            String authority = "(((((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[;:&=\\+$,])*@)?((([0-9a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?\\.)*[a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?(\\.)?)|([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})|(\\[(((([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?)?)|(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?))(:[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})?)|(::[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}))\\]))(:[0-9]*)?)?)|((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[$,;:@&=\\+])+))";
            String scheme = "[a-zA-Z][A-Za-z0-9\\+\\-\\.]*";
            String relSegment = "(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[;@&=\\+$,])+";
            String absPath = "/(((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*)(/((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*))*)";
            String relPath = "(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[;@&=\\+$,])+(/(((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*)(/((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*))*))?";
            String netPath = "//(((((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[;:&=\\+$,])*@)?((([0-9a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?\\.)*[a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?(\\.)?)|([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})|(\\[(((([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?)?)|(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?))(:[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})?)|(::[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}))\\]))(:[0-9]*)?)?)|((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[$,;:@&=\\+])+))(/(((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*)(/((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*))*))?";
            String uricNoSlash = "(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[;\\?:@&=\\+$,])";
            String opaquePart = "(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[;\\?:@&=\\+$,])(([;/\\?:@&=\\+$,\\[\\]]|([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}))*";
            String hierPart = "((//(((((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[;:&=\\+$,])*@)?((([0-9a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?\\.)*[a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?(\\.)?)|([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})|(\\[(((([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?)?)|(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?))(:[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})?)|(::[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}))\\]))(:[0-9]*)?)?)|((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[$,;:@&=\\+])+))(/(((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*)(/((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*))*))?)|(/(((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*)(/((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*))*)))(\\?([;/\\?:@&=\\+$,\\[\\]]|([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2})*)?";
            String relativeURI = "((//(((((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[;:&=\\+$,])*@)?((([0-9a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?\\.)*[a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?(\\.)?)|([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})|(\\[(((([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?)?)|(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?))(:[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})?)|(::[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}))\\]))(:[0-9]*)?)?)|((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[$,;:@&=\\+])+))(/(((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*)(/((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*))*))?)|(/(((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*)(/((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*))*))|((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[;@&=\\+$,])+(/(((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*)(/((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*))*))?))(\\?([;/\\?:@&=\\+$,\\[\\]]|([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2})*)?";
            String absoluteURI = "[a-zA-Z][A-Za-z0-9\\+\\-\\.]*:((((//(((((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[;:&=\\+$,])*@)?((([0-9a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?\\.)*[a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?(\\.)?)|([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})|(\\[(((([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?)?)|(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?))(:[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})?)|(::[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}))\\]))(:[0-9]*)?)?)|((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[$,;:@&=\\+])+))(/(((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*)(/((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*))*))?)|(/(((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*)(/((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*))*)))(\\?([;/\\?:@&=\\+$,\\[\\]]|([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2})*)?)|((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[;\\?:@&=\\+$,])(([;/\\?:@&=\\+$,\\[\\]]|([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}))*))";
            String uriRef = "([a-zA-Z][A-Za-z0-9\\+\\-\\.]*:((((//(((((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[;:&=\\+$,])*@)?((([0-9a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?\\.)*[a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?(\\.)?)|([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})|(\\[(((([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?)?)|(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?))(:[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})?)|(::[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}))\\]))(:[0-9]*)?)?)|((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[$,;:@&=\\+])+))(/(((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*)(/((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*))*))?)|(/(((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*)(/((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*))*)))(\\?([;/\\?:@&=\\+$,\\[\\]]|([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2})*)?)|((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[;\\?:@&=\\+$,])(([;/\\?:@&=\\+$,\\[\\]]|([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}))*))|((//(((((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[;:&=\\+$,])*@)?((([0-9a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?\\.)*[a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?(\\.)?)|([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})|(\\[(((([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?)?)|(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?))(:[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})?)|(::[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}))\\]))(:[0-9]*)?)?)|((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[$,;:@&=\\+])+))(/(((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*)(/((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*))*))?)|(/(((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*)(/((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*))*))|((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[;@&=\\+$,])+(/(((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*)(/((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*))*))?))(\\?([;/\\?:@&=\\+$,\\[\\]]|([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2})*)?)?(#([;/\\?:@&=\\+$,\\[\\]]|([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2})*)?";
            ANYURI_REGEXP = RegExpFactory.createFactory().compile("([a-zA-Z][A-Za-z0-9\\+\\-\\.]*:((((//(((((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[;:&=\\+$,])*@)?((([0-9a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?\\.)*[a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?(\\.)?)|([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})|(\\[(((([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?)?)|(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?))(:[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})?)|(::[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}))\\]))(:[0-9]*)?)?)|((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[$,;:@&=\\+])+))(/(((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*)(/((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*))*))?)|(/(((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*)(/((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*))*)))(\\?([;/\\?:@&=\\+$,\\[\\]]|([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2})*)?)|((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[;\\?:@&=\\+$,])(([;/\\?:@&=\\+$,\\[\\]]|([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}))*))|((//(((((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[;:&=\\+$,])*@)?((([0-9a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?\\.)*[a-zA-Z]([0-9A-Za-z\\-]*[0-9a-zA-Z])?(\\.)?)|([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})|(\\[(((([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?)?)|(::([0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4})*)?))(:[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})?)|(::[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}))\\]))(:[0-9]*)?)?)|((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[$,;:@&=\\+])+))(/(((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*)(/((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*))*))?)|(/(((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*)(/((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*))*))|((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[;@&=\\+$,])+(/(((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*)(/((([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*(;(([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2}|[:@&=\\+$,])*)*))*))?))(\\?([;/\\?:@&=\\+$,\\[\\]]|([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2})*)?)?(#([;/\\?:@&=\\+$,\\[\\]]|([0-9a-zA-Z]|[\\-_\\.!~\\*'\\(\\)])|%[0-9a-fA-F]{2})*)?");
        }
        catch (ParseException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }
}

