/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.util.concurrent.Callable;
import org.apache.http.client.HttpClient;
import org.jboss.logging.Logger;
import org.keycloak.adapters.HttpClientBuilder;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.authentication.ClientCredentialsProviderUtils;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.adapters.rotation.HardcodedPublicKeyLocator;
import org.keycloak.adapters.rotation.JWKPublicKeyLocator;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.PemUtils;
import org.keycloak.enums.TokenStore;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.representations.adapters.config.AdapterHttpClientConfig;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.util.SystemPropertiesJsonParserFactory;

public class KeycloakDeploymentBuilder {
    private static final Logger log = Logger.getLogger(KeycloakDeploymentBuilder.class);
    protected KeycloakDeployment deployment = new KeycloakDeployment();

    protected KeycloakDeploymentBuilder() {
    }

    protected KeycloakDeployment internalBuild(final AdapterConfig adapterConfig) {
        PolicyEnforcerConfig policyEnforcerConfig;
        if (adapterConfig.getRealm() == null) {
            throw new RuntimeException("Must set 'realm' in config");
        }
        this.deployment.setRealm(adapterConfig.getRealm());
        String resource = adapterConfig.getResource();
        if (resource == null) {
            throw new RuntimeException("Must set 'resource' in config");
        }
        this.deployment.setResourceName(resource);
        String realmKeyPem = adapterConfig.getRealmKey();
        if (realmKeyPem != null) {
            try {
                PublicKey realmKey = PemUtils.decodePublicKey((String)realmKeyPem);
                HardcodedPublicKeyLocator pkLocator = new HardcodedPublicKeyLocator(realmKey);
                this.deployment.setPublicKeyLocator(pkLocator);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            JWKPublicKeyLocator pkLocator = new JWKPublicKeyLocator();
            this.deployment.setPublicKeyLocator(pkLocator);
        }
        if (adapterConfig.getSslRequired() != null) {
            this.deployment.setSslRequired(SslRequired.valueOf((String)adapterConfig.getSslRequired().toUpperCase()));
        } else {
            this.deployment.setSslRequired(SslRequired.EXTERNAL);
        }
        if (adapterConfig.getConfidentialPort() != -1) {
            this.deployment.setConfidentialPort(adapterConfig.getConfidentialPort());
        }
        if (adapterConfig.getTokenStore() != null) {
            this.deployment.setTokenStore(TokenStore.valueOf((String)adapterConfig.getTokenStore().toUpperCase()));
        } else {
            this.deployment.setTokenStore(TokenStore.SESSION);
        }
        if (adapterConfig.getTokenCookiePath() != null) {
            this.deployment.setAdapterStateCookiePath(adapterConfig.getTokenCookiePath());
        }
        if (adapterConfig.getPrincipalAttribute() != null) {
            this.deployment.setPrincipalAttribute(adapterConfig.getPrincipalAttribute());
        }
        this.deployment.setResourceCredentials(adapterConfig.getCredentials());
        this.deployment.setClientAuthenticator(ClientCredentialsProviderUtils.bootstrapClientAuthenticator(this.deployment));
        this.deployment.setPublicClient(adapterConfig.isPublicClient());
        this.deployment.setUseResourceRoleMappings(adapterConfig.isUseResourceRoleMappings());
        this.deployment.setExposeToken(adapterConfig.isExposeToken());
        if (adapterConfig.isCors()) {
            this.deployment.setCors(true);
            this.deployment.setCorsMaxAge(adapterConfig.getCorsMaxAge());
            this.deployment.setCorsAllowedHeaders(adapterConfig.getCorsAllowedHeaders());
            this.deployment.setCorsAllowedMethods(adapterConfig.getCorsAllowedMethods());
            this.deployment.setCorsExposedHeaders(adapterConfig.getCorsExposedHeaders());
        }
        if (adapterConfig.isPkce()) {
            this.deployment.setPkce(true);
        }
        this.deployment.setBearerOnly(adapterConfig.isBearerOnly());
        this.deployment.setAutodetectBearerOnly(adapterConfig.isAutodetectBearerOnly());
        this.deployment.setEnableBasicAuth(adapterConfig.isEnableBasicAuth());
        this.deployment.setAlwaysRefreshToken(adapterConfig.isAlwaysRefreshToken());
        this.deployment.setRegisterNodeAtStartup(adapterConfig.isRegisterNodeAtStartup());
        this.deployment.setRegisterNodePeriod(adapterConfig.getRegisterNodePeriod());
        this.deployment.setTokenMinimumTimeToLive(adapterConfig.getTokenMinimumTimeToLive());
        this.deployment.setMinTimeBetweenJwksRequests(adapterConfig.getMinTimeBetweenJwksRequests());
        this.deployment.setPublicKeyCacheTtl(adapterConfig.getPublicKeyCacheTtl());
        this.deployment.setIgnoreOAuthQueryParameter(adapterConfig.isIgnoreOAuthQueryParameter());
        this.deployment.setRewriteRedirectRules(adapterConfig.getRedirectRewriteRules());
        this.deployment.setVerifyTokenAudience(adapterConfig.isVerifyTokenAudience());
        if (realmKeyPem == null && adapterConfig.isBearerOnly() && adapterConfig.getAuthServerUrl() == null) {
            throw new IllegalArgumentException("For bearer auth, you must set the realm-public-key or auth-server-url");
        }
        if (!(adapterConfig.getAuthServerUrl() != null || this.deployment.isBearerOnly() && realmKeyPem != null)) {
            throw new RuntimeException("You must specify auth-server-url");
        }
        this.deployment.setClient(this.createHttpClientProducer(adapterConfig));
        this.deployment.setAuthServerBaseUrl(adapterConfig);
        if (adapterConfig.getTurnOffChangeSessionIdOnLogin() != null) {
            this.deployment.setTurnOffChangeSessionIdOnLogin(adapterConfig.getTurnOffChangeSessionIdOnLogin());
        }
        if ((policyEnforcerConfig = adapterConfig.getPolicyEnforcerConfig()) != null) {
            this.deployment.setPolicyEnforcer(new Callable<PolicyEnforcer>(){
                PolicyEnforcer policyEnforcer;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public PolicyEnforcer call() {
                    if (this.policyEnforcer == null) {
                        KeycloakDeployment keycloakDeployment = KeycloakDeploymentBuilder.this.deployment;
                        synchronized (keycloakDeployment) {
                            if (this.policyEnforcer == null) {
                                this.policyEnforcer = new PolicyEnforcer(KeycloakDeploymentBuilder.this.deployment, adapterConfig);
                            }
                        }
                    }
                    return this.policyEnforcer;
                }
            });
        }
        return this.deployment;
    }

    private Callable<HttpClient> createHttpClientProducer(final AdapterConfig adapterConfig) {
        return new Callable<HttpClient>(){
            private HttpClient client;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public HttpClient call() {
                if (this.client == null) {
                    KeycloakDeployment keycloakDeployment = KeycloakDeploymentBuilder.this.deployment;
                    synchronized (keycloakDeployment) {
                        if (this.client == null) {
                            this.client = new HttpClientBuilder().build((AdapterHttpClientConfig)adapterConfig);
                        }
                    }
                }
                return this.client;
            }
        };
    }

    public static KeycloakDeployment build(InputStream is) {
        CryptoIntegration.init((ClassLoader)KeycloakDeploymentBuilder.class.getClassLoader());
        AdapterConfig adapterConfig = KeycloakDeploymentBuilder.loadAdapterConfig(is);
        return new KeycloakDeploymentBuilder().internalBuild(adapterConfig);
    }

    public static AdapterConfig loadAdapterConfig(InputStream is) {
        AdapterConfig adapterConfig;
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new SystemPropertiesJsonParserFactory());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        try {
            adapterConfig = (AdapterConfig)mapper.readValue(is, AdapterConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return adapterConfig;
    }

    public static KeycloakDeployment build(AdapterConfig adapterConfig) {
        return new KeycloakDeploymentBuilder().internalBuild(adapterConfig);
    }
}

