/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.WebTarget;
import java.net.URI;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.net.ssl.SSLContext;
import org.keycloak.admin.client.Config;
import org.keycloak.admin.client.resource.BearerAuthFilter;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RealmsResource;
import org.keycloak.admin.client.resource.ServerInfoResource;
import org.keycloak.admin.client.spi.ResteasyClientProvider;
import org.keycloak.admin.client.token.TokenManager;

public class Keycloak
implements AutoCloseable {
    private static volatile ResteasyClientProvider CLIENT_PROVIDER = Keycloak.resolveResteasyClientProvider();
    private final Config config;
    private final TokenManager tokenManager;
    private final String authToken;
    private final WebTarget target;
    private final Client client;
    private boolean closed = false;

    private static ResteasyClientProvider resolveResteasyClientProvider() {
        Iterator<ResteasyClientProvider> providers = ServiceLoader.load(ResteasyClientProvider.class).iterator();
        if (providers.hasNext()) {
            ResteasyClientProvider provider = providers.next();
            if (providers.hasNext()) {
                throw new IllegalArgumentException("Multiple " + ResteasyClientProvider.class + " implementations found");
            }
            return provider;
        }
        return Keycloak.createDefaultResteasyClientProvider();
    }

    private static ResteasyClientProvider createDefaultResteasyClientProvider() {
        try {
            return (ResteasyClientProvider)Keycloak.class.getClassLoader().loadClass("org.keycloak.admin.client.spi.ResteasyClientClassicProvider").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception cause) {
            throw new RuntimeException("Could not instantiate default client provider", cause);
        }
    }

    public static void setClientProvider(ResteasyClientProvider provider) {
        CLIENT_PROVIDER = provider;
    }

    public static ResteasyClientProvider getClientProvider() {
        return CLIENT_PROVIDER;
    }

    Keycloak(String serverUrl, String realm, String username, String password, String clientId, String clientSecret, String grantType, Client resteasyClient, String authtoken, String scope) {
        this.config = new Config(serverUrl, realm, username, password, clientId, clientSecret, grantType, scope);
        this.client = resteasyClient != null ? resteasyClient : Keycloak.newRestEasyClient(null, null, false);
        this.authToken = authtoken;
        this.tokenManager = authtoken == null ? new TokenManager(this.config, this.client) : null;
        this.target = this.client.target(this.config.getServerUrl());
        this.target.register((Object)this.newAuthFilter());
    }

    private static Client newRestEasyClient(Object customJacksonProvider, SSLContext sslContext, boolean disableTrustManager) {
        return CLIENT_PROVIDER.newRestEasyClient(customJacksonProvider, sslContext, disableTrustManager);
    }

    private BearerAuthFilter newAuthFilter() {
        return this.authToken != null ? new BearerAuthFilter(this.authToken) : new BearerAuthFilter(this.tokenManager);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String username, String password, String clientId, String clientSecret, SSLContext sslContext, Object customJacksonProvider, boolean disableTrustManager, String authToken, String scope) {
        return new Keycloak(serverUrl, realm, username, password, clientId, clientSecret, "password", Keycloak.newRestEasyClient(customJacksonProvider, sslContext, disableTrustManager), authToken, scope);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String username, String password, String clientId, String clientSecret, SSLContext sslContext, Object customJacksonProvider, boolean disableTrustManager, String authToken) {
        return new Keycloak(serverUrl, realm, username, password, clientId, clientSecret, "password", Keycloak.newRestEasyClient(customJacksonProvider, sslContext, disableTrustManager), authToken, null);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String username, String password, String clientId, String clientSecret) {
        return Keycloak.getInstance(serverUrl, realm, username, password, clientId, clientSecret, null, null, false, null);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String username, String password, String clientId, String clientSecret, SSLContext sslContext) {
        return Keycloak.getInstance(serverUrl, realm, username, password, clientId, clientSecret, sslContext, null, false, null);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String username, String password, String clientId, String clientSecret, SSLContext sslContext, Object customJacksonProvider) {
        return Keycloak.getInstance(serverUrl, realm, username, password, clientId, clientSecret, sslContext, customJacksonProvider, false, null);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String username, String password, String clientId) {
        return Keycloak.getInstance(serverUrl, realm, username, password, clientId, null, null, null, false, null);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String username, String password, String clientId, SSLContext sslContext) {
        return Keycloak.getInstance(serverUrl, realm, username, password, clientId, null, sslContext, null, false, null);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String clientId, String authToken) {
        return Keycloak.getInstance(serverUrl, realm, null, null, clientId, null, null, null, false, authToken);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String clientId, String authToken, SSLContext sllSslContext) {
        return Keycloak.getInstance(serverUrl, realm, null, null, clientId, null, sllSslContext, null, false, authToken);
    }

    public RealmsResource realms() {
        return CLIENT_PROVIDER.targetProxy(this.target, RealmsResource.class);
    }

    public RealmResource realm(String realmName) {
        return this.realms().realm(realmName);
    }

    public ServerInfoResource serverInfo() {
        return CLIENT_PROVIDER.targetProxy(this.target, ServerInfoResource.class);
    }

    public TokenManager tokenManager() {
        return this.tokenManager;
    }

    public <T> T proxy(Class<T> proxyClass, URI absoluteURI) {
        WebTarget register = (WebTarget)this.client.target(absoluteURI).register((Object)this.newAuthFilter());
        return CLIENT_PROVIDER.targetProxy(register, proxyClass);
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.tokenManager != null) {
            try {
                this.tokenManager.logout();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.client.close();
    }

    public boolean isClosed() {
        return this.closed;
    }
}

