/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client.resource;

import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.ManagementPermissionReference;
import org.keycloak.representations.idm.ManagementPermissionRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public interface RoleResource {
    @PUT
    @Path(value="/management/permissions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ManagementPermissionReference setPermissions(ManagementPermissionRepresentation var1);

    @GET
    @Path(value="/management/permissions")
    @Produces(value={"application/json"})
    public ManagementPermissionReference getPermissions();

    @GET
    @Produces(value={"application/json"})
    public RoleRepresentation toRepresentation();

    @PUT
    @Consumes(value={"application/json"})
    public void update(RoleRepresentation var1);

    @DELETE
    public void remove();

    @GET
    @Path(value="composites")
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getRoleComposites();

    @GET
    @Path(value="composites/realm")
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getRealmRoleComposites();

    @GET
    @Path(value="composites/clients/{appName}")
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getClientRoleComposites(@PathParam(value="appName") String var1);

    @POST
    @Path(value="composites")
    @Consumes(value={"application/json"})
    public void addComposites(List<RoleRepresentation> var1);

    @DELETE
    @Path(value="composites")
    @Consumes(value={"application/json"})
    public void deleteComposites(List<RoleRepresentation> var1);

    @GET
    @Path(value="users")
    @Produces(value={"application/json"})
    public Set<UserRepresentation> getRoleUserMembers();

    @GET
    @Path(value="users")
    @Produces(value={"application/json"})
    public Set<UserRepresentation> getRoleUserMembers(@QueryParam(value="first") Integer var1, @QueryParam(value="max") Integer var2);

    @GET
    @Path(value="groups")
    @Produces(value={"application/json"})
    public Set<GroupRepresentation> getRoleGroupMembers();

    @GET
    @Path(value="groups")
    @Produces(value={"application/json"})
    public Set<GroupRepresentation> getRoleGroupMembers(@QueryParam(value="first") Integer var1, @QueryParam(value="max") Integer var2);
}

