/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.authorization.client.representation.ServerConfiguration;
import org.keycloak.authorization.client.resource.AuthorizationResource;
import org.keycloak.authorization.client.resource.ProtectionResource;
import org.keycloak.authorization.client.util.Http;
import org.keycloak.authorization.client.util.TokenCallable;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.util.SystemPropertiesJsonParserFactory;

public class AuthzClient {
    private final Http http;
    private TokenCallable patSupplier;
    private final ServerConfiguration serverConfiguration;
    private final Configuration configuration;

    public static AuthzClient create() throws RuntimeException {
        InputStream configStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("keycloak.json");
        return AuthzClient.create(configStream);
    }

    public static AuthzClient create(InputStream configStream) throws RuntimeException {
        if (configStream == null) {
            throw new IllegalArgumentException("Config input stream can not be null");
        }
        try {
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new SystemPropertiesJsonParserFactory());
            mapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
            return AuthzClient.create((Configuration)((Object)mapper.readValue(configStream, Configuration.class)));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not parse configuration.", e);
        }
    }

    public static AuthzClient create(Configuration configuration) {
        CryptoIntegration.init((ClassLoader)AuthzClient.class.getClassLoader());
        return new AuthzClient(configuration);
    }

    public ProtectionResource protection() {
        return new ProtectionResource(this.http, this.serverConfiguration, this.configuration, this.createPatSupplier());
    }

    public ProtectionResource protection(final String accessToken) {
        return new ProtectionResource(this.http, this.serverConfiguration, this.configuration, new TokenCallable(this.http, this.configuration, this.serverConfiguration){

            @Override
            public String call() {
                return accessToken;
            }

            @Override
            protected boolean isRetry() {
                return false;
            }
        });
    }

    public ProtectionResource protection(String userName, String password) {
        return new ProtectionResource(this.http, this.serverConfiguration, this.configuration, this.createPatSupplier(userName, password));
    }

    public AuthorizationResource authorization() {
        return new AuthorizationResource(this.configuration, this.serverConfiguration, this.http, null);
    }

    public AuthorizationResource authorization(final String accessToken) {
        return new AuthorizationResource(this.configuration, this.serverConfiguration, this.http, new TokenCallable(this.http, this.configuration, this.serverConfiguration){

            @Override
            public String call() {
                return accessToken;
            }

            @Override
            protected boolean isRetry() {
                return false;
            }
        });
    }

    public AuthorizationResource authorization(String userName, String password) {
        return this.authorization(userName, password, null);
    }

    public AuthorizationResource authorization(String userName, String password, String scope) {
        return new AuthorizationResource(this.configuration, this.serverConfiguration, this.http, this.createRefreshableAccessTokenSupplier(userName, password, scope));
    }

    public AccessTokenResponse obtainAccessToken() {
        return this.http.post(this.serverConfiguration.getTokenEndpoint()).authentication().client().response().json(AccessTokenResponse.class).execute();
    }

    public AccessTokenResponse obtainAccessToken(String userName, String password) {
        return this.http.post(this.serverConfiguration.getTokenEndpoint()).authentication().oauth2ResourceOwnerPassword(userName, password).response().json(AccessTokenResponse.class).execute();
    }

    public ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    private AuthzClient(Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Client configuration can not be null.");
        }
        String configurationUrl = configuration.getAuthServerUrl();
        if (configurationUrl == null) {
            throw new IllegalArgumentException("Configuration URL can not be null.");
        }
        configurationUrl = KeycloakUriBuilder.fromUri((String)configurationUrl).clone().path("/realms/{realm-name}/.well-known/uma2-configuration").build(new Object[]{configuration.getRealm()}).toString();
        this.configuration = configuration;
        this.http = new Http(configuration, configuration.getClientCredentialsProvider());
        try {
            this.serverConfiguration = this.http.get(configurationUrl).response().json(ServerConfiguration.class).execute();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not obtain configuration from server [" + configurationUrl + "].", e);
        }
    }

    public TokenCallable createPatSupplier(String userName, String password) {
        if (this.patSupplier == null) {
            this.patSupplier = this.createRefreshableAccessTokenSupplier(userName, password);
        }
        return this.patSupplier;
    }

    public TokenCallable createPatSupplier() {
        return this.createPatSupplier(null, null);
    }

    private TokenCallable createRefreshableAccessTokenSupplier(String userName, String password) {
        return this.createRefreshableAccessTokenSupplier(userName, password, null);
    }

    private TokenCallable createRefreshableAccessTokenSupplier(String userName, String password, String scope) {
        return new TokenCallable(userName, password, scope, this.http, this.configuration, this.serverConfiguration);
    }
}

