/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.util.crypto;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

class ASN1Decoder {
    private final ByteArrayInputStream is;
    private final int limit;
    private int count;

    ASN1Decoder(byte[] bytes) {
        this.is = new ByteArrayInputStream(bytes);
        this.count = 0;
        this.limit = bytes.length;
    }

    public static ASN1Decoder create(byte[] bytes) {
        return new ASN1Decoder(bytes);
    }

    public List<byte[]> readSequence() throws IOException {
        byte[] bytes;
        int tag = this.readTag();
        int tagNo = this.readTagNumber(tag);
        if (tagNo != 16) {
            throw new IOException("Invalid Sequence tag " + tagNo);
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (int length = this.readLength(); length > 0; length -= bytes.length) {
            bytes = this.readNext();
            result.add(bytes);
        }
        return result;
    }

    public BigInteger readInteger() throws IOException {
        int tag = this.readTag();
        int tagNo = this.readTagNumber(tag);
        if (tagNo != 2) {
            throw new IOException("Invalid Integer tag " + tagNo);
        }
        int length = this.readLength();
        byte[] bytes = this.read(length);
        return new BigInteger(bytes);
    }

    byte[] readNext() throws IOException {
        this.mark();
        int tag = this.readTag();
        this.readTagNumber(tag);
        int length = this.readLength();
        return this.read(length += this.reset());
    }

    int readTag() throws IOException {
        int tag = this.read();
        if (tag < 0) {
            throw new EOFException("EOF found inside tag value.");
        }
        return tag;
    }

    int readTagNumber(int tag) throws IOException {
        int tagNo = tag & 0x1F;
        if (tagNo == 31) {
            tagNo = 0;
            int b = this.read();
            if ((b & 0x7F) == 0) {
                throw new IOException("corrupted stream - invalid high tag number found");
            }
            while (b >= 0 && (b & 0x80) != 0) {
                tagNo |= b & 0x7F;
                tagNo <<= 7;
                b = this.read();
            }
            if (b < 0) {
                throw new EOFException("EOF found inside tag value.");
            }
            tagNo |= b & 0x7F;
        }
        return tagNo;
    }

    int readLength() throws IOException {
        int length = this.read();
        if (length < 0) {
            throw new EOFException("EOF found when length expected");
        }
        if (length == 128) {
            return -1;
        }
        if (length > 127) {
            int size = length & 0x7F;
            if (size > 4) {
                throw new IOException("DER length more than 4 bytes: " + size);
            }
            length = 0;
            for (int i = 0; i < size; ++i) {
                int next = this.read();
                if (next < 0) {
                    throw new EOFException("EOF found reading length");
                }
                length = (length << 8) + next;
            }
            if (length < 0) {
                throw new IOException("corrupted stream - negative length found");
            }
            if (length >= this.limit) {
                throw new IOException("corrupted stream - out of bounds length found");
            }
        }
        return length;
    }

    byte[] read(int length) throws IOException {
        int bytesRead;
        byte[] bytes = new byte[length];
        for (int totalBytesRead = 0; totalBytesRead < length; totalBytesRead += bytesRead) {
            bytesRead = this.is.read(bytes, totalBytesRead, length - totalBytesRead);
            if (bytesRead != -1) continue;
            throw new IOException(String.format("EOF found reading %d bytes", length));
        }
        this.count += length;
        return bytes;
    }

    void mark() {
        this.count = 0;
        this.is.mark(this.is.available());
    }

    int reset() {
        int tmp = this.count;
        this.is.reset();
        return tmp;
    }

    int read() {
        int tmp = this.is.read();
        if (tmp >= 0) {
            ++this.count;
        }
        return tmp;
    }
}

