/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.clientscope;

import java.util.Set;
import java.util.function.BiFunction;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.authorization.ClientScopePolicyRepresentation;

public class ClientScopePolicyProvider
implements PolicyProvider {
    private final BiFunction<Policy, AuthorizationProvider, ClientScopePolicyRepresentation> representationFunction;

    public ClientScopePolicyProvider(BiFunction<Policy, AuthorizationProvider, ClientScopePolicyRepresentation> representationFunction) {
        this.representationFunction = representationFunction;
    }

    public void close() {
    }

    public void evaluate(Evaluation evaluation) {
        Policy policy = evaluation.getPolicy();
        Set clientScopeIds = this.representationFunction.apply(policy, evaluation.getAuthorizationProvider()).getClientScopes();
        AuthorizationProvider authorizationProvider = evaluation.getAuthorizationProvider();
        RealmModel realm = authorizationProvider.getKeycloakSession().getContext().getRealm();
        Identity identity = evaluation.getContext().getIdentity();
        for (ClientScopePolicyRepresentation.ClientScopeDefinition clientScopeDefinition : clientScopeIds) {
            ClientScopeModel clientScope = realm.getClientScopeById(clientScopeDefinition.getId());
            if (clientScope == null) continue;
            boolean hasClientScope = this.hasClientScope(identity, clientScope);
            if (!hasClientScope && clientScopeDefinition.isRequired()) {
                evaluation.deny();
                return;
            }
            if (!hasClientScope) continue;
            evaluation.grant();
        }
    }

    private boolean hasClientScope(Identity identity, ClientScopeModel clientScope) {
        String[] clientScopes;
        String clientScopeName = clientScope.getName();
        for (String scope : clientScopes = identity.getAttributes().getValue("scope").asString(0).split(" ")) {
            if (!clientScopeName.equals(scope)) continue;
            return true;
        }
        return false;
    }
}

