/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import org.keycloak.common.util.Time;

public class Retry {
    public static int execute(Runnable runnable, int attemptsCount, long intervalMillis) {
        int iteration = 0;
        while (true) {
            try {
                runnable.run();
                return iteration;
            }
            catch (AssertionError | RuntimeException e) {
                ++iteration;
                if (--attemptsCount > 0) {
                    try {
                        if (intervalMillis <= 0L) continue;
                        Thread.sleep(intervalMillis);
                    }
                    catch (InterruptedException ie) {
                        ie.addSuppressed((Throwable)e);
                        throw new RuntimeException(ie);
                    }
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public static int executeWithBackoff(AdvancedRunnable runnable, int attemptsCount, int intervalBaseMillis) {
        return Retry.executeWithBackoff(runnable, null, attemptsCount, intervalBaseMillis);
    }

    public static int executeWithBackoff(AdvancedRunnable runnable, ThrowableCallback throwableCallback, int attemptsCount, int intervalBaseMillis) {
        long duration = 0L;
        for (int i = 0; i < attemptsCount; ++i) {
            duration += (long)Retry.computeIterationBase(intervalBaseMillis, i);
        }
        return Retry.executeWithBackoff(runnable, throwableCallback, Duration.ofMillis(duration), intervalBaseMillis);
    }

    public static int executeWithBackoff(AdvancedRunnable runnable, Duration timeout, int intervalBaseMillis) {
        return Retry.executeWithBackoff(runnable, null, timeout, intervalBaseMillis);
    }

    public static int executeWithBackoff(AdvancedRunnable runnable, ThrowableCallback throwableCallback, Duration timeout, int intervalBaseMillis) {
        long maximumTime = Time.currentTimeMillis() + timeout.toMillis();
        int iteration = 0;
        while (true) {
            try {
                runnable.run(iteration);
                return iteration;
            }
            catch (AssertionError | RuntimeException e) {
                if (throwableCallback != null) {
                    throwableCallback.handleThrowable(iteration, (Throwable)e);
                }
                ++iteration;
                if (Time.currentTimeMillis() < maximumTime) {
                    try {
                        if (intervalBaseMillis <= 0) continue;
                        int delay = Retry.computeBackoffInterval(intervalBaseMillis, iteration);
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException ie) {
                        ie.addSuppressed((Throwable)e);
                        throw new RuntimeException(ie);
                    }
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public static int computeBackoffInterval(int base, int iteration) {
        return ThreadLocalRandom.current().nextInt(Retry.computeIterationBase(base, iteration));
    }

    private static int computeIterationBase(int base, int iteration) {
        return base * (1 << iteration);
    }

    public static <T> T call(Supplier<T> supplier, int attemptsCount, long intervalMillis) {
        int iteration = 0;
        while (true) {
            try {
                return supplier.get(iteration);
            }
            catch (AssertionError | Exception e) {
                ++iteration;
                if (--attemptsCount > 0) {
                    try {
                        if (intervalMillis <= 0L) continue;
                        Thread.sleep(intervalMillis);
                    }
                    catch (InterruptedException ie) {
                        ie.addSuppressed((Throwable)e);
                        throw new RuntimeException(ie);
                    }
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public static interface AdvancedRunnable {
        public void run(int var1);
    }

    public static interface ThrowableCallback {
        public void handleThrowable(int var1, Throwable var2);
    }

    public static interface Supplier<T> {
        public T get(int var1);
    }
}

