/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.forms.RealmBean;
import org.keycloak.forms.RegisterBean;
import org.keycloak.forms.UrlBean;
import org.keycloak.forms.model.SocialProvider;
import org.keycloak.services.resources.flows.Urls;

public class SocialBean {
    private RealmBean realm;
    private RegisterBean registerBean;
    private UrlBean url;
    private List<SocialProvider> providers;

    public SocialBean(RealmBean realm, List<org.keycloak.social.SocialProvider> providers, RegisterBean registerBean, UrlBean url) {
        this.realm = realm;
        this.registerBean = registerBean;
        this.url = url;
        URI baseURI = url.getBaseURI();
        UriBuilder socialLoginUrlBuilder = UriBuilder.fromUri((URI)Urls.socialRedirectToProviderAuth((URI)baseURI, (String)realm.getId()));
        this.providers = new LinkedList<SocialProvider>();
        for (org.keycloak.social.SocialProvider p : providers) {
            String loginUrl = socialLoginUrlBuilder.replaceQueryParam("provider_id", new Object[]{p.getId()}).build(new Object[0]).toString();
            this.providers.add(new SocialProvider(p.getId(), p.getName(), loginUrl));
        }
    }

    public List<SocialProvider> getProviders() {
        return this.providers;
    }

    public boolean isDisplaySocialProviders() {
        return this.realm.isSocial() && !this.providers.isEmpty() && !this.registerBean.isSocialRegistration();
    }

    public RealmBean getRealm() {
        return this.realm;
    }

    public void setRealm(RealmBean realm) {
        this.realm = realm;
    }

    public UrlBean getUrl() {
        return this.url;
    }

    public void setUrl(UrlBean url) {
        this.url = url;
    }

    public RegisterBean getRegisterBean() {
        return this.registerBean;
    }

    public void setRegisterBean(RegisterBean registerBean) {
        this.registerBean = registerBean;
    }
}

