/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms;

import java.util.HashMap;
import java.util.Map;
import org.keycloak.forms.RealmBean;

public class TemplateBean {
    private RealmBean realm;
    private String theme = "default";
    private String themeUrl;
    private Map<String, Object> themeConfig;
    private String formsPath;

    public TemplateBean(RealmBean realm, String contextPath) {
        this.formsPath = contextPath + "/forms";
        this.theme = "default";
        this.themeUrl = this.formsPath + "/theme/" + this.theme;
        this.themeConfig = new HashMap<String, Object>();
        this.themeConfig.put("styles", this.themeUrl + "/styles.css");
        if (realm.isSaas()) {
            this.themeConfig.put("logo", this.themeUrl + "/img/red-hat-logo.png");
            this.themeConfig.put("background", this.themeUrl + "/img/login-screen-background.jpg");
            this.themeConfig.put("displayPoweredBy", false);
        } else {
            this.themeConfig.put("background", this.themeUrl + "/img/customer-login-screen-bg2.jpg");
            this.themeConfig.put("displayPoweredBy", true);
        }
    }

    public String getFormsPath() {
        return this.formsPath;
    }

    public Map<String, Object> getThemeConfig() {
        return this.themeConfig;
    }

    public String getTheme() {
        return this.theme;
    }

    public String getThemeUrl() {
        return this.themeUrl;
    }

    public RealmBean getRealm() {
        return this.realm;
    }

    public void setRealm(RealmBean realm) {
        this.realm = realm;
    }
}

