/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.service;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.forms.LoginBean;
import org.keycloak.forms.MessageBean;
import org.keycloak.forms.OAuthGrantBean;
import org.keycloak.forms.RealmBean;
import org.keycloak.forms.RegisterBean;
import org.keycloak.forms.SocialBean;
import org.keycloak.forms.TemplateBean;
import org.keycloak.forms.TotpBean;
import org.keycloak.forms.UrlBean;
import org.keycloak.forms.UserBean;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.RoleModel;
import org.keycloak.services.FormService;

public class FormServiceImpl
implements FormService {
    private static final Logger log = Logger.getLogger(FormServiceImpl.class);
    private static final String ID = "FormServiceId";
    private static final String BUNDLE = "org.keycloak.forms.messages";
    private final Map<String, CommandCommon> commandMap = new HashMap<String, CommandCommon>();

    public FormServiceImpl() {
        this.commandMap.put("login.ftl", new CommandLogin());
        this.commandMap.put("register.ftl", new CommandRegister());
        this.commandMap.put("account.ftl", new CommandCommon());
        this.commandMap.put("login-update-profile.ftl", new CommandCommon());
        this.commandMap.put("password.ftl", new CommandCommon());
        this.commandMap.put("login-reset-password.ftl", new CommandCommon());
        this.commandMap.put("login-update-password.ftl", new CommandCommon());
        this.commandMap.put("access.ftl", new CommandCommon());
        this.commandMap.put("social.ftl", new CommandCommon());
        this.commandMap.put("totp.ftl", new CommandTotp());
        this.commandMap.put("login-config-totp.ftl", new CommandTotp());
        this.commandMap.put("login-totp.ftl", new CommandLoginTotp());
        this.commandMap.put("login-verify-email.ftl", new CommandCommon());
        this.commandMap.put("login-oauth-grant.ftl", new CommandOAuthGrant());
    }

    public String getId() {
        return ID;
    }

    public String process(String pageId, FormService.FormServiceDataBean dataBean) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        ResourceBundle rb = ResourceBundle.getBundle(BUNDLE);
        attributes.put("rb", rb);
        if (dataBean.getMessage() != null) {
            attributes.put("message", new MessageBean(dataBean.getMessage(), dataBean.getMessageType(), rb));
        }
        RealmBean realm = new RealmBean(dataBean.getRealm());
        attributes.put("template", new TemplateBean(realm, dataBean.getContextPath()));
        if (this.commandMap.containsKey(pageId)) {
            this.commandMap.get(pageId).exec(attributes, dataBean);
        }
        return this.processFmTemplate(pageId, attributes);
    }

    private String processFmTemplate(String temp, Map<String, Object> input) {
        StringWriter out = new StringWriter();
        Configuration cfg = new Configuration();
        try {
            cfg.setClassForTemplateLoading(FormServiceImpl.class, "/META-INF/resources/forms/theme/default");
            Template template = cfg.getTemplate(temp);
            template.process(input, (Writer)out);
        }
        catch (IOException e) {
            log.error("Failed to load the template " + temp, (Throwable)e);
        }
        catch (TemplateException e) {
            log.error("Failed to process template " + temp, (Throwable)e);
        }
        return ((Object)out).toString();
    }

    private class CommandOAuthGrant
    extends CommandCommon {
        private CommandOAuthGrant() {
        }

        @Override
        public void exec(Map<String, Object> attributes, FormService.FormServiceDataBean dataBean) {
            super.exec(attributes, dataBean);
            OAuthGrantBean oauth = new OAuthGrantBean();
            oauth.setAction(dataBean.getOAuthAction());
            oauth.setResourceRolesRequested((MultivaluedMap<String, RoleModel>)dataBean.getOAuthResourceRolesRequested());
            oauth.setClient(dataBean.getOAuthClient());
            oauth.setoAuthCode(dataBean.getOAuthCode());
            oauth.setRealmRolesRequested(dataBean.getOAuthRealmRolesRequested());
            attributes.put("oauth", oauth);
        }
    }

    private class CommandRegister
    extends CommandCommon {
        private CommandRegister() {
        }

        @Override
        public void exec(Map<String, Object> attributes, FormService.FormServiceDataBean dataBean) {
            super.exec(attributes, dataBean);
            RegisterBean register = new RegisterBean((MultivaluedMap<String, String>)dataBean.getFormData(), dataBean.getSocialRegistration());
            attributes.put("register", register);
            SocialBean social = new SocialBean(this.realm, dataBean.getSocialProviders(), register, this.url);
            attributes.put("social", social);
        }
    }

    private class CommandLogin
    extends CommandCommon {
        private CommandLogin() {
        }

        @Override
        public void exec(Map<String, Object> attributes, FormService.FormServiceDataBean dataBean) {
            super.exec(attributes, dataBean);
            RegisterBean register = new RegisterBean((MultivaluedMap<String, String>)dataBean.getFormData(), dataBean.getSocialRegistration());
            SocialBean social = new SocialBean(this.realm, dataBean.getSocialProviders(), register, this.url);
            attributes.put("social", social);
        }
    }

    private class CommandLoginTotp
    extends CommandCommon {
        private CommandLoginTotp() {
        }

        @Override
        public void exec(Map<String, Object> attributes, FormService.FormServiceDataBean dataBean) {
            super.exec(attributes, dataBean);
            RegisterBean register = new RegisterBean((MultivaluedMap<String, String>)dataBean.getFormData(), dataBean.getSocialRegistration());
            SocialBean social = new SocialBean(this.realm, dataBean.getSocialProviders(), register, this.url);
            attributes.put("social", social);
        }
    }

    private class CommandTotp
    extends CommandCommon {
        private CommandTotp() {
        }

        @Override
        public void exec(Map<String, Object> attributes, FormService.FormServiceDataBean dataBean) {
            super.exec(attributes, dataBean);
            attributes.put("totp", new TotpBean(this.user, dataBean.getContextPath()));
        }
    }

    private class CommandCommon {
        protected RealmBean realm;
        protected UrlBean url;
        protected UserBean user;
        protected LoginBean login;

        private CommandCommon() {
        }

        public void exec(Map<String, Object> attributes, FormService.FormServiceDataBean dataBean) {
            this.realm = new RealmBean(dataBean.getRealm());
            String referrer = dataBean.getQueryParam("referrer");
            String referrerUri = null;
            if (referrer != null) {
                for (ApplicationModel a : dataBean.getRealm().getApplications()) {
                    if (!a.getName().equals(referrer)) continue;
                    referrerUri = a.getBaseUrl();
                    break;
                }
            }
            this.url = new UrlBean(this.realm, dataBean.getBaseURI(), referrerUri);
            this.url.setSocialRegistration(dataBean.getSocialRegistration());
            this.user = new UserBean(dataBean.getUserModel());
            this.login = new LoginBean(this.realm, (MultivaluedMap<String, String>)dataBean.getFormData());
            attributes.put("realm", this.realm);
            attributes.put("url", this.url);
            attributes.put("user", this.user);
            attributes.put("login", this.login);
        }
    }
}

